<?php
	// li.menu-item-has-children:hover ul{display:block}
	/* Add class to <a> tag in menu  (by default, it had no class)*/
	add_filter( 'nav_menu_link_attributes', 'add_attributes_to_a', 10, 4 );
	add_filter( 'nav_menu_link_attributes', 'add_attributes_to_a', 10, 4 );
	function add_attributes_to_a($atts, $item, $args, $depth) {
		$atts['class'] = $atts['class'] ?? "";
		$atts['data-toggle'] =  $atts['data-toggle'] ?? "";
		
		if ( $depth == 0) { // top level
			$atts['class'] .= " top_link";
		}
		
		if(isset($item->classes)){
			if (in_array('menu-item-has-children', $item->classes)) { // has submenu
				$atts['class'] .= " dropdown-toggle";
				$atts['data-toggle'] = "dropdown";
				// $atts['aria-haspopup'] = "true";
			}
			
			if (in_array('current-menu-item', $item->classes)) { // active
				// $atts['class'] = "active";
			}
		}
		
		if ( $item->ID == 17) { // add Class if Id = 17 (example) 
			// $atts['class'] .= " large flat button";
		}
		
		// $atts['class'] = "orphan item bullet";
		return $atts;
	}
	/* End : dd class to <a> tag in menu  (by default, it had no class)*/
	
	
	class submenu_Walker extends Walker_Nav_Menu
	{
		private $last_top_item_id = null;
    
		function start_lvl( &$output, $depth = 0, $args = array() ) {
			$indent = str_repeat("\t", $depth);
			$output .= <<<HTMLCODE
\n$indent
				<ul class="sub-menu">
\n
HTMLCODE;
		}
		// Edit the dropdown stucture 
		function end_lvl( &$output, $depth = 0, $args = array() ) {
			$indent = str_repeat("\t", $depth);
			$output .= <<<HTMLCODE
$indent
				</ul>
\n
HTMLCODE;

		}
		
		// add class to <li> that have a submenu
		function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 )  {
			$atts = array();
			$has_children = $args->has_children;
			$ID = $item->ID;
			$add_class_to_each_level = false;
			
			// Add custom classes
			if ( $has_children ) {
				$item->classes[] .= 'dropdown';
				
				// $atts['aria-expanded'] = "false";
				// $atts['aria-haspopup'] = "true";
			}
			
			// Add those class if this is the current item
			if (in_array('current-menu-item', $item->classes)) {
				$item->classes[] .= 'current_page_item';
				$item->classes[] .= 'active';
				$item->classes[] .= 'current';
				// $atts['id'] = "current";
			}
		
			// add attribute depending on the level
			if($add_class_to_each_level){
				if($depth == 0){
					$item->classes[] .= 'level-1';
				} else if($depth == 1){
					$item->classes[] .= 'level-2';
				}
			}
			
			// add attribute and classes to specific id
			// $ID = $item->ID;
			// if($ID == 31){
				// $atts['aria-haspopup'] = "true";
				// $atts['id'] = "menu-item-search";
				// $item->classes[] = 'bookbutton';
			// }
			
			// Add 'last' class to the last top-level item only
			if ($depth === 0 && $item->ID === $this->last_top_item_id) {
				// $item->classes[] = 'last';
			}
			
			
			
			
			
			$item->title   = html_entity_decode($item->title); // Encode the HTML inside menu item
			
			$start_output_length = strlen($output);
			
			// Let the parent generate the output first
			parent::start_el( $output, $item, $depth, $args );
			
			// Get only the part that was just added by parent
			$new_output = substr($output, $start_output_length);

			// Inject a <span> after </a> ONLY if item has children
			if ( !empty($args->has_children) ) {
				/* 
				$new_output = preg_replace(
					'/(<a[^>]*>.*?<\/a>)/is',
					'$1<span data-toggle="dropdown" class="lvl2-toggle glyphicon glyphicon-chevron-down"></span>',
					$new_output,
					1
				); 
				*/
			}

			// Replace that part of output with the updated version
			$output = substr($output, 0, $start_output_length) . $new_output;
			
			if(is_array($atts) && count($atts) && isset($ID)){  // to be able to insert custom attribute like data-...
				$atts_text = "";
				foreach($atts as $key=>$value){
					if($key != "id"){
						$atts_text .= " $key=\"$value\"";
					} 
				}
				// echo "/(<li[^>]+id=\"menu-item-$ID\"[^>]+)(>)/";
				$output = preg_replace("/(<li[^>]+id=\"menu-item-$ID\"[^>]+)(>)/","$1$atts_text$2",$output);
				if(isset($atts['id'])){
					$output = preg_replace("/(<li[^>]+id=\")menu-item-$ID(\"[^>]+>)/","$1".$atts['id']."$2",$output);
				}
			}
		} 
		 
		// Corrected walk() method signature
		public function walk($elements, $max_depth, ...$args) {
			// First find the last top-level item
			foreach ($elements as $element) {
				if ($element->menu_item_parent == 0) {
					$this->last_top_item_id = $element->ID;
				}
			}
			
			return parent::walk($elements, $max_depth, ...$args);
		}
		
		
		
		function display_element( $element, &$children_elements, $max_depth, $depth, $args, &$output ) {
			$id_field = $this->db_fields['id'];

			if ( is_object( $args[0] ) ) {
				$args[0]->has_children = !empty( $children_elements[$element->$id_field] );
			}

			return parent::display_element( $element, $children_elements, $max_depth, $depth, $args, $output );
		}
	}
	
	
	
	
	/* Stop removal of some tags */
	function uncoverwp_tiny_mce_fix( $init )
	{
		// '*' didn't work at all at any option
		
		// html elements being stripped
		// $init['valid_elements'] = '*[*]';
		// $init['extended_valid_elements'] = '*[*]';
		// $init['custom_elements'] = 'link, image'; // "link" break the WYIWYG when added
		$init['custom_elements'] = 'wix-image, defs, image'; // "image" is still getting removed
		
		$init['extended_valid_elements'] = 'div[*], article[*],a[*],svg[*],g[*],path[*]'; // to avoid <i> from being removed on mybitsend.com
		
		// don't remove line breaks
		$init['remove_linebreaks'] = false;
		
		// convert newline characters to BR
		// $init['convert_newlines_to_brs'] = true;
		
		/// This option allows you to disable TinyMCE’s default behavior of removing <br> tags at the end of block elements.
		$init['remove_redundant_brs'] = false;
		// By default all links with a target of _blank will get a rel attribute of noopener.
		$init['allow_unsafe_link_target'] = true;
		// pass back to wordpress
		
		// Allow onclick attribute in anchor tags.
        if ( ! isset( $init['extended_valid_elements'] ) ) {
			$init['extended_valid_elements'] = '';
        } else {
			$init['extended_valid_elements'] .= ',';
        }

		$init['extended_valid_elements'] .= 'button[href|rel|class|id|style|onclick]'; // not remove onclick attr from button tag for example when save
		
		$init['valid_children']="+a[div|p|ul|ol|li|h1|h2|h3|h4|h5|h5|h6]"; // to not remove <a> that is wrapping a <div>
		
		return $init;
	}
	add_filter( 'tiny_mce_before_init', 'uncoverwp_tiny_mce_fix' );
	/* End: Stop removal of some tags */
	
	/*  fix jquery conflict caused by jquery */
	/* 
	fix_jquery_conflict();
	function fix_jquery_conflict(){
		// add_action( 'wp_print_scripts', 'my_deregister_javascript', 100 );
		// function my_deregister_javascript() {
			// wp_deregister_script( 'contact-form-7' );
			// wp_deregister_script( 'elementor' );
		// }
		wp_deregister_script('jquery');
		wp_register_script('jquery', "", false, null); // remove added jquery code
		wp_enqueue_script('jquery');
	}
	*/
	/* Redirect missing pagincation pages to frontpage */
		/**
	 * @author daniele raimondi W3B snc
	 * @version 0.4
	 * @abstract This workaround fixes a problem with page pagination, where you can request
	 * n paginated part of a (non-paginated)page from 2 to 2147483647 (max 32 signed int value)
	 * and you will never get a 404 error. WP returns instead the page itself  if it's a not-paginated page, 
	 * or the first page if you request n-paginated pages, from n+1 on.
	 */

	function fix_missing_404_on_paginated_page() {
		global $wp_query,$page,$paged;

		if (!isset($page)) $page = get_query_var('page');
		if (!isset($paged)) $paged = get_query_var('paged');
		if (is_page() || is_single()) {
			$realpagescount = count( explode( '<!--nextpage-->', $wp_query->post->post_content ) );

			if ( (isset($page) && isset($realpagescount) && $page >= $realpagescount) || (is_paged() && isset($paged) && $paged >=0 ) ){
			//wp_redirect( home_url() );
				nocache_headers();
				status_header( '404' );
				$wp_query->is_404=true;
				$wp_query->is_single=false;
				$wp_query->is_singular=false;
				$wp_query->post_count=0;
				$wp_query->page=0;
				$wp_query->query['page']='';
				$wp_query->query['posts']=array();
				$wp_query->query['post']=array();
				$wp_query->posts=array();
				$wp_query->post=array();
				$wp_query->queried_object=array();
				$wp_query->queried_object_id=0;
				locate_template('index.php', true);
				exit;
			}
		}
	}
	add_action('template_redirect', 'fix_missing_404_on_paginated_page');
	/* End: Redirect missing pagincation pages to frontpage */
	
	/* Create Shortcode */
	// Replace get_bloginfo('url') with shortcode '[get_bloginfo]url[/get_bloginfo]' when save from dashoard
	add_filter( 'wp_insert_post_data', 'change_post_data_before_save', 10, 2 );
	function change_post_data_before_save( $data, $postarr ) {	
		//error_log( 'Data: ' . var_export( $data, true ) );
		//error_log( 'PostArr: ' . var_export( $postarr, true ) );
		
		if ( 'publish' == $data[ 'post_status' ] ) {
			$url = preg_quote( get_bloginfo('url'),'/');
			$html = preg_replace( '/'.$url.'/is','[get_bloginfo]url[/get_bloginfo]', $data[ 'post_content' ]);
			
			preg_match_all('/\<script(.*?)?\>(.|\s)*?\<\/script\>/i', $html, $scripts);
			if(count($scripts[0])){
				foreach($scripts[0] as $style_origin){
					if(preg_match('/<br \/>/',$style_origin)){
						// echo $script."<br><br><br><br>";
						$script = preg_replace('/<br \/>$/m','',$style_origin); // remove the added <br \> after each line inside the <script>
						$html = str_replace($style_origin,$script,$html);
					}
				}
			}
			
			$data[ 'post_content' ] = $html;
		}
		return $data;
	}
	
	// Replace shortcode '[get_bloginfo]url[/get_bloginfo]' with get_bloginfo('url') before display on WYSIWYG dashboard
	function change_post_data_before_display_on_wysiwyg( $content  ) {	
		$url = get_bloginfo('url');
		$content = preg_replace('/\[get_bloginfo\]url\[\/get_bloginfo\]/is', $url, $content); 
		return $content;
	}
	
	function rest_prepare_filter( $response, $post, $request )
	{
		// if( in_array( 'content', $response->data) )
		$response->data['content']['raw'] = change_post_data_before_display_on_wysiwyg( $response->data['content']['raw'] );
		return $response;
	}
	add_filter( "rest_prepare_post", 'rest_prepare_filter' , 10, 3 );
	add_filter( "rest_prepare_page", 'rest_prepare_filter' , 10, 3 );
	  
	// for Classic Editor
	function content_load ($content) { $content = change_post_data_before_display_on_wysiwyg($content); return $content; } 
	add_filter('the_editor_content','content_load',2);  
	
	
	// Update the content of the page
	function replace_shortcode_before_display($content) {
		$url = get_bloginfo('url');
		$content = preg_replace('/\[get_bloginfo\]url\[\/get_bloginfo\]/is', $url, $content); 
		return $content;
    }
    add_filter('the_content', 'replace_shortcode_before_display');
	
	// Update Yoast twitter image
	function filter_wpseo_twitter_image( $img ) { 
    	return replace_shortcode_before_display($img); 
	}; 
	add_filter( 'wpseo_twitter_image', 'filter_wpseo_twitter_image', 10, 1 ); 
    
	// Update yoast schema graph
	function update_schema( $data ) { 
		return replace_shortcode_before_display($data); 
	}
	// add_filter( 'wpseo_schema_article', 'update_schema' );
	// add_filter( 'wpseo_schema_webpage', 'update_schema' );
	// add_filter( 'wpseo_schema_website', 'update_schema' );
	add_filter( 'wpseo_schema_mainimage', 'update_schema' );
  /* End : Create Shortcode */
	
	// create shortcode
	/* function bloginfo_fnc( $atts, $content = "" ) {
		return get_bloginfo($content);
	}
	add_shortcode( 'get_bloginfo', 'bloginfo_fnc' ); // [get_bloginfo]url[/get_bloginfo]
	add_filter( 'wp_kses_allowed_html', 'wpse_allow_iframe_kses_html',1,1 ); // WordPress by default not allow iframe in kses allow HTML list
																			 // So I using this filer so <iframe src="[get_bloginfo]url[/get_bloginfo]"> is executed 
																				// same for img, script and css
	function wpse_allow_iframe_kses_html( $allowedposttags ) {

	  // Here add tags and attributes you want to allow
		$allowedposttags['iframe']=array(
			'frameborder' => true,
			'src' => true,
		); 
		$allowedposttags['input']=array(
			'src' => true,
		); 
		
		$allowedposttags['img']=array(
			'src' => true,
			'srcset' => true,
			'data-src' => true,
			'data-srcset' => true,
			'data-image' => true,
			'data-retina' => true,
			'data-lazyload' => true,
			'data-lazy-src' => true,
			'data-lazy-srcset' => true,
		);

		$allowedposttags['source']=array(
			'src' => true,
		);
		$allowedposttags['form']=array(
			'action' => true,
		);
		
		$allowedposttags['frame']=array(
			'src' => true,
		);
		
		$allowedposttags['script']=array(
			'src' => true,
		); 
	  
		$allowedposttags['link']=array(
			'href' => true,
		);
		
		$allowedposttags['table']=array(
			'background' => true,
		);
	
		return $allowedposttags;
	}
	 */
	
	// remove og:location, og:image and yoast-schema-graph from wordpress-seo plugin
	function intervik_wpseo_frontend_presenters( $presenters ) {
		if($matches = preg_grep('/Image_Presenter|Schema_Presenter|Locale_Presenter/', $presenters)) return array_diff($presenters, $matches);
			else {
				return $presenters;
			}
	}

	add_filter('wpseo_frontend_presenter_classes', 'intervik_wpseo_frontend_presenters', 10, 1);
	
	// add Class to body classes
	function textdomain_body_classes( $classes ) {
		 
		$classes[] = ''; // 'class_1 class_2 ect'
		
		return $classes;
	}
	add_filter( 'body_class', 'textdomain_body_classes' );

	// Display thumbnails
	add_theme_support( 'post-thumbnails' ); 
	
	// Register menus
	register_nav_menus(
		array(
            'header-menu' => __( 'Header Menu', 'text_domain' ),
            'header-submenu'  => __( 'Header Submenu', 'text_domain' ),
        ) 
	);
	
	// change excerpt length
	function wpdocs_custom_excerpt_length( $length ) {
		return 9;
	}
	add_filter( 'excerpt_length', 'wpdocs_custom_excerpt_length', 999 );
	
	// Register widget
	function arphabet_widgets_init() {

		register_sidebar( array(
			'name'          => 'Blog Sidebar',
			'id'            => 'blog_sidebar',
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );

	}
	add_action( 'widgets_init', 'arphabet_widgets_init' );
	
	// Show empty categories
	add_filter('widget_categories_args','show_empty_categories_links');
	function show_empty_categories_links($args) {
		$args['hide_empty'] = 0;
		return $args;
	}
	
	// Breadcrumbs
	function custom_breadcrumbs() {
		   
		// Settings
		$separator          = ' &gt; ';
		$breadcrums_id      = 'breadcrumbs';
		$breadcrums_class   = 'breadcrumbs';
		$home_title         = 'Home';
		  
		// If you have any custom post types with custom taxonomies, put the taxonomy name below (e.g. product_cat)
		$custom_taxonomy    = 'product_cat';
		   
		// Get the query & post information
		global $post,$wp_query;
		   
		// Do not display on the homepage
		if ( !is_front_page() ) {
		   
			// Build the breadcrums
			// echo '<ul id="' . $breadcrums_id . '" class="' . $breadcrums_class . '">';
			   
			// Home page
			echo '<strong><a class="bread-link bread-home" href="' . get_home_url() . '" title="' . $home_title . '">' . $home_title . '</a></strong>';
			echo $separator; 
			   
			if ( is_archive() && !is_tax() && !is_category() && !is_tag() ) {
				  
				echo '<strong class="bread-current bread-archive">' . post_type_archive_title($prefix, false) . '</strong>';
				  
			} else if ( is_archive() && is_tax() && !is_category() && !is_tag() ) {
				  
				// If post is a custom post type
				$post_type = get_post_type();
				  
				// If it is a custom post type display name and link
				if($post_type != 'post') {
					  
					$post_type_object = get_post_type_object($post_type);
					$post_type_archive = get_post_type_archive_link($post_type);
				  
					echo '<a class="bread-cat bread-custom-post-type-' . $post_type . '" href="' . $post_type_archive . '" title="' . $post_type_object->labels->name . '">' . $post_type_object->labels->name . '</a>';
					echo $separator;
				  
				}
				  
				$custom_tax_name = get_queried_object()->name;
				echo '<strong class="bread-current bread-archive">' . $custom_tax_name . '</strong>';
				  
			} else if ( is_single() ) {
				  
				// If post is a custom post type
				$post_type = get_post_type();
				  
				// If it is a custom post type display name and link
				if($post_type != 'post') {
					  
					$post_type_object = get_post_type_object($post_type);
					$post_type_archive = get_post_type_archive_link($post_type);
				  
					echo '<a class="bread-cat bread-custom-post-type-' . $post_type . '" href="' . $post_type_archive . '" title="' . $post_type_object->labels->name . '">' . $post_type_object->labels->name . '</a>';
					echo $separator;
				  
				}
				  
				// Get post category info
				$category = get_the_category();
				 
				if(!empty($category)) {
				  
					// Get last category post is in
					$last_category = end(array_values($category));
					  
					// Get parent any categories and create array
					$get_cat_parents = rtrim(get_category_parents($last_category->term_id, true, ','),',');
					$cat_parents = explode(',',$get_cat_parents);
					  
					// Loop through parent categories and store in variable $cat_display
					$cat_display = '';
					foreach($cat_parents as $parents) {
						$cat_display .= $parents;
						$cat_display .= $separator;
					}
				 
				}
				  
				// If it's a custom post type within a custom taxonomy
				$taxonomy_exists = taxonomy_exists($custom_taxonomy);
				if(empty($last_category) && !empty($custom_taxonomy) && $taxonomy_exists) {
					   
					$taxonomy_terms = get_the_terms( $post->ID, $custom_taxonomy );
					$cat_id         = $taxonomy_terms[0]->term_id;
					$cat_nicename   = $taxonomy_terms[0]->slug;
					$cat_link       = get_term_link($taxonomy_terms[0]->term_id, $custom_taxonomy);
					$cat_name       = $taxonomy_terms[0]->name;
				   
				}
				  
				// Check if the post is in a category
				if(!empty($last_category)) {
					echo $cat_display;
					echo '<strong class="bread-current bread-' . $post->ID . '" title="' . get_the_title() . '">' . get_the_title() . '</strong>';
					  
				// Else if post is in a custom taxonomy
				} else if(!empty($cat_id)) {
					  
					echo '<a class="bread-cat bread-cat-' . $cat_id . ' bread-cat-' . $cat_nicename . '" href="' . $cat_link . '" title="' . $cat_name . '">' . $cat_name . '</a>';
					echo $separator ;
					echo '<strong class="bread-current bread-' . $post->ID . '" title="' . get_the_title() . '">' . get_the_title() . '</strong>';
				  
				} else {
					  
					echo '<strong class="bread-current bread-' . $post->ID . '" title="' . get_the_title() . '">' . get_the_title() . '</strong>';
					  
				}
				  
			} else if ( is_category() ) {
				   
				// Category page
				echo '<strong class="bread-current bread-cat">' . single_cat_title('', false) . '</strong>';
				   
			} else if ( is_page() ) {
				   
				// Standard page
				if( $post->post_parent ){
					   
					// If child page, get parents 
					$anc = get_post_ancestors( $post->ID );
					   
					// Get parents in the right order
					$anc = array_reverse($anc);
					   
					// Parent page loop
					foreach ( $anc as $ancestor ) {
						$parents .= '<a class="bread-parent bread-parent-' . $ancestor . '" href="' . get_permalink($ancestor) . '" title="' . get_the_title($ancestor) . '">' . get_the_title($ancestor) . '</a>';
						$parents .= $separator . ' ';
					}
					   
					// Display parent pages
					echo $parents;
					   
					// Current page
					echo '<strong title="' . get_the_title() . '"> ' . get_the_title() . '</strong>';
					   
				} else {
					   
					// Just display current page if not parents
					echo '<strong class="bread-current bread-' . $post->ID . '"> ' . get_the_title() . '</strong>';
					   
				}
				   
			} else if ( is_tag() ) {
				   
				// Tag page
				   
				// Get tag information
				$term_id        = get_query_var('tag_id');
				$taxonomy       = 'post_tag';
				$args           = 'include=' . $term_id;
				$terms          = get_terms( $taxonomy, $args );
				$get_term_id    = $terms[0]->term_id;
				$get_term_slug  = $terms[0]->slug;
				$get_term_name  = $terms[0]->name;
				   
				// Display the tag name
				echo '<strong class="bread-current bread-tag-' . $get_term_id . ' bread-tag-' . $get_term_slug . '">' . $get_term_name . '</strong>';
			   
			} elseif ( is_day() ) {
				   
				// Day archive
				   
				// Year link
				echo '<a class="bread-year bread-year-' . get_the_time('Y') . '" href="' . get_year_link( get_the_time('Y') ) . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . ' Archives</a>';
				echo  $separator;
				   
				// Month link
				echo '<a class="bread-month bread-month-' . get_the_time('m') . '" href="' . get_month_link( get_the_time('Y'), get_the_time('m') ) . '" title="' . get_the_time('M') . '">' . get_the_time('M') . ' Archives</a>';
				echo $separator;
				   
				// Day display
				echo '<strong class="bread-current bread-' . get_the_time('j') . '"> ' . get_the_time('jS') . ' ' . get_the_time('M') . ' Archives</strong>';
				   
			} else if ( is_month() ) {
				   
				// Month Archive
				   
				// Year link
				echo '<a class="bread-year bread-year-' . get_the_time('Y') . '" href="' . get_year_link( get_the_time('Y') ) . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . ' Archives</a>';
				echo $separator ;
				   
				// Month display
				echo '<strong class="bread-month bread-month-' . get_the_time('m') . '" title="' . get_the_time('M') . '">' . get_the_time('M') . ' Archives</strong>';
				   
			} else if ( is_year() ) {
				   
				// Display year archive
				echo '<strong class="bread-current bread-current-' . get_the_time('Y') . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . ' Archives</strong>';
				   
			} else if ( is_author() ) {
				   
				// Auhor archive
				   
				// Get the author information
				global $author;
				$userdata = get_userdata( $author );
				   
				// Display author name
				echo '<strong class="bread-current bread-current-' . $userdata->user_nicename . '" title="' . $userdata->display_name . '">' . 'Author: ' . $userdata->display_name . '</strong>';
			   
			} else if ( get_query_var('paged') ) {
				   
				// Paginated archives
				echo '<strong class="bread-current bread-current-' . get_query_var('paged') . '" title="Page ' . get_query_var('paged') . '">'.__('Page') . ' ' . get_query_var('paged') . '</strong>';
				   
			} else if ( is_search() ) {
			   
				// Search results page
				echo '<strong class="bread-current bread-current-' . get_search_query() . '" title="Search results for: ' . get_search_query() . '">Search results for: ' . get_search_query() . '</strong>';
			   
			} elseif ( is_404() ) {
				   
				// 404 page
				echo '' . 'Error 404' . '';
			}
		   
			// echo '</ul>';
			   
		}
		   
	}
	
	/* Add separator */
		// add_filter('wp_nav_menu_items', 'wcr_wp_nav_menu_items', 11, 2); // this create problem when there are submenus 
																			// DOC: https://wpcrumbs.com/how-to-add-a-separator-between-menu-items-in-a-wp-nav-menu-the-easy-way/
		function wcr_wp_nav_menu_items($items, $args) {
			// $separator = '';
			$separator = '&middot;';
			// $separator = '<li class="sep"></lI>';
			
			// process the list
			$document = new DOMDocument();
			$document->loadHTML(mb_convert_encoding($items, 'HTML-ENTITIES', 'UTF-8'));

			$lis = $document->getElementsByTagName('li');

			if (empty($lis)) {
				return $items;
			}

			// rebuild the list
			$new_items = array();
			foreach ($lis as $li) {
				var_dump($document->saveXML($li));
				$new_items[] = $document->saveXML($li);
			}
			echo implode($separator, $new_items);
			echo "----------------------------<br>";
			// die;
			return implode($separator, $new_items);
		}
	/* End: Add separator */
?>