DROP TABLE IF EXISTS `wp_commentmeta`;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;




DROP TABLE IF EXISTS `wp_comments`;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `wp_comments` VALUES("1","1","A WordPress Commenter","wapuu@wordpress.example","https://wordpress.org/","","2025-12-07 14:26:27","2025-12-07 14:26:27","Hi, this is a comment.
To get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.
Commenter avatars come from <a href=\"https://gravatar.com/\">Gravatar</a>.","0","1","","comment","0","0");



DROP TABLE IF EXISTS `wp_links`;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;




DROP TABLE IF EXISTS `wp_options`;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=157 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `wp_options` VALUES("1","cron","a:6:{i:1765121187;a:2:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1765122987;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765124787;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765203987;a:2:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765204042;a:1:{s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}","on");
INSERT INTO `wp_options` VALUES("2","siteurl","http://peka777.net","on");
INSERT INTO `wp_options` VALUES("3","home","http://peka777.net","on");
INSERT INTO `wp_options` VALUES("4","blogname","Peka777 : Daftar 1 ID Game Anda Bisa Menikmati Fitur Selamanya","on");
INSERT INTO `wp_options` VALUES("5","blogdescription","","on");
INSERT INTO `wp_options` VALUES("6","users_can_register","0","on");
INSERT INTO `wp_options` VALUES("7","admin_email","adikurnawan@ymail.com","on");
INSERT INTO `wp_options` VALUES("8","start_of_week","1","on");
INSERT INTO `wp_options` VALUES("9","use_balanceTags","0","on");
INSERT INTO `wp_options` VALUES("10","use_smilies","1","on");
INSERT INTO `wp_options` VALUES("11","require_name_email","1","on");
INSERT INTO `wp_options` VALUES("12","comments_notify","1","on");
INSERT INTO `wp_options` VALUES("13","posts_per_rss","10","on");
INSERT INTO `wp_options` VALUES("14","rss_use_excerpt","0","on");
INSERT INTO `wp_options` VALUES("15","mailserver_url","mail.example.com","on");
INSERT INTO `wp_options` VALUES("16","mailserver_login","login@example.com","on");
INSERT INTO `wp_options` VALUES("17","mailserver_pass","","on");
INSERT INTO `wp_options` VALUES("18","mailserver_port","110","on");
INSERT INTO `wp_options` VALUES("19","default_category","1","on");
INSERT INTO `wp_options` VALUES("20","default_comment_status","open","on");
INSERT INTO `wp_options` VALUES("21","default_ping_status","open","on");
INSERT INTO `wp_options` VALUES("22","default_pingback_flag","1","on");
INSERT INTO `wp_options` VALUES("23","posts_per_page","10","on");
INSERT INTO `wp_options` VALUES("24","date_format","F j, Y","on");
INSERT INTO `wp_options` VALUES("25","time_format","g:i a","on");
INSERT INTO `wp_options` VALUES("26","links_updated_date_format","F j, Y g:i a","on");
INSERT INTO `wp_options` VALUES("27","comment_moderation","0","on");
INSERT INTO `wp_options` VALUES("28","moderation_notify","1","on");
INSERT INTO `wp_options` VALUES("29","permalink_structure","/%category%/%postname%/","on");
INSERT INTO `wp_options` VALUES("30","rewrite_rules","a:98:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=1&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:31:\".+?/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\".+?/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\".+?/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\".+?/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\".+?/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\".+?/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"(.+?)/([^/]+)/embed/?$\";s:63:\"index.php?category_name=$matches[1]&name=$matches[2]&embed=true\";s:26:\"(.+?)/([^/]+)/trackback/?$\";s:57:\"index.php?category_name=$matches[1]&name=$matches[2]&tb=1\";s:46:\"(.+?)/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?category_name=$matches[1]&name=$matches[2]&feed=$matches[3]\";s:41:\"(.+?)/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?category_name=$matches[1]&name=$matches[2]&feed=$matches[3]\";s:34:\"(.+?)/([^/]+)/page/?([0-9]{1,})/?$\";s:70:\"index.php?category_name=$matches[1]&name=$matches[2]&paged=$matches[3]\";s:41:\"(.+?)/([^/]+)/comment-page-([0-9]{1,})/?$\";s:70:\"index.php?category_name=$matches[1]&name=$matches[2]&cpage=$matches[3]\";s:30:\"(.+?)/([^/]+)(?:/([0-9]+))?/?$\";s:69:\"index.php?category_name=$matches[1]&name=$matches[2]&page=$matches[3]\";s:20:\".+?/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:30:\".+?/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:50:\".+?/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:45:\".+?/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:45:\".+?/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:26:\".+?/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:33:\"(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:14:\"(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:26:\"(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:33:\"(.+?)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&cpage=$matches[2]\";s:8:\"(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";}","auto");
INSERT INTO `wp_options` VALUES("31","hack_file","0","on");
INSERT INTO `wp_options` VALUES("32","blog_charset","UTF-8","on");
INSERT INTO `wp_options` VALUES("33","moderation_keys","","off");
INSERT INTO `wp_options` VALUES("34","active_plugins","a:2:{i:0;s:39:\"custom-permalinks/custom-permalinks.php\";i:1;s:24:\"wordpress-seo/wp-seo.php\";}","on");
INSERT INTO `wp_options` VALUES("35","category_base","","on");
INSERT INTO `wp_options` VALUES("36","ping_sites","http://rpc.pingomatic.com/","on");
INSERT INTO `wp_options` VALUES("37","comment_max_links","2","on");
INSERT INTO `wp_options` VALUES("38","gmt_offset","0","on");
INSERT INTO `wp_options` VALUES("39","default_email_category","1","on");
INSERT INTO `wp_options` VALUES("40","recently_edited","","off");
INSERT INTO `wp_options` VALUES("41","template","mgz9rgj2nkn8ysxvapb2q499386","on");
INSERT INTO `wp_options` VALUES("42","stylesheet","mgz9rgj2nkn8ysxvapb2q499386","on");
INSERT INTO `wp_options` VALUES("43","comment_registration","0","on");
INSERT INTO `wp_options` VALUES("44","html_type","text/html","on");
INSERT INTO `wp_options` VALUES("45","use_trackback","0","on");
INSERT INTO `wp_options` VALUES("46","default_role","subscriber","on");
INSERT INTO `wp_options` VALUES("47","db_version","58975","on");
INSERT INTO `wp_options` VALUES("48","uploads_use_yearmonth_folders","1","on");
INSERT INTO `wp_options` VALUES("49","upload_path","","on");
INSERT INTO `wp_options` VALUES("50","blog_public","1","on");
INSERT INTO `wp_options` VALUES("51","default_link_category","2","on");
INSERT INTO `wp_options` VALUES("52","show_on_front","page","on");
INSERT INTO `wp_options` VALUES("53","tag_base","","on");
INSERT INTO `wp_options` VALUES("54","show_avatars","1","on");
INSERT INTO `wp_options` VALUES("55","avatar_rating","G","on");
INSERT INTO `wp_options` VALUES("56","upload_url_path","","on");
INSERT INTO `wp_options` VALUES("57","thumbnail_size_w","150","on");
INSERT INTO `wp_options` VALUES("58","thumbnail_size_h","150","on");
INSERT INTO `wp_options` VALUES("59","thumbnail_crop","1","on");
INSERT INTO `wp_options` VALUES("60","medium_size_w","300","on");
INSERT INTO `wp_options` VALUES("61","medium_size_h","300","on");
INSERT INTO `wp_options` VALUES("62","avatar_default","mystery","on");
INSERT INTO `wp_options` VALUES("63","large_size_w","1024","on");
INSERT INTO `wp_options` VALUES("64","large_size_h","1024","on");
INSERT INTO `wp_options` VALUES("65","image_default_link_type","none","on");
INSERT INTO `wp_options` VALUES("66","image_default_size","","on");
INSERT INTO `wp_options` VALUES("67","image_default_align","","on");
INSERT INTO `wp_options` VALUES("68","close_comments_for_old_posts","0","on");
INSERT INTO `wp_options` VALUES("69","close_comments_days_old","14","on");
INSERT INTO `wp_options` VALUES("70","thread_comments","1","on");
INSERT INTO `wp_options` VALUES("71","thread_comments_depth","5","on");
INSERT INTO `wp_options` VALUES("72","page_comments","0","on");
INSERT INTO `wp_options` VALUES("73","comments_per_page","50","on");
INSERT INTO `wp_options` VALUES("74","default_comments_page","newest","on");
INSERT INTO `wp_options` VALUES("75","comment_order","asc","on");
INSERT INTO `wp_options` VALUES("76","sticky_posts","a:0:{}","on");
INSERT INTO `wp_options` VALUES("77","widget_categories","a:0:{}","on");
INSERT INTO `wp_options` VALUES("78","widget_text","a:0:{}","on");
INSERT INTO `wp_options` VALUES("79","widget_rss","a:0:{}","on");
INSERT INTO `wp_options` VALUES("80","uninstall_plugins","a:0:{}","off");
INSERT INTO `wp_options` VALUES("81","timezone_string","","on");
INSERT INTO `wp_options` VALUES("82","page_for_posts","0","on");
INSERT INTO `wp_options` VALUES("83","page_on_front","1","on");
INSERT INTO `wp_options` VALUES("84","default_post_format","0","on");
INSERT INTO `wp_options` VALUES("85","link_manager_enabled","0","on");
INSERT INTO `wp_options` VALUES("86","finished_splitting_shared_terms","1","on");
INSERT INTO `wp_options` VALUES("87","site_icon","0","on");
INSERT INTO `wp_options` VALUES("88","medium_large_size_w","768","on");
INSERT INTO `wp_options` VALUES("89","medium_large_size_h","0","on");
INSERT INTO `wp_options` VALUES("90","wp_page_for_privacy_policy","3","on");
INSERT INTO `wp_options` VALUES("91","show_comments_cookies_opt_in","1","on");
INSERT INTO `wp_options` VALUES("92","admin_email_lifespan","1780669587","on");
INSERT INTO `wp_options` VALUES("93","disallowed_keys","","off");
INSERT INTO `wp_options` VALUES("94","comment_previously_approved","1","on");
INSERT INTO `wp_options` VALUES("95","auto_plugin_theme_update_emails","a:0:{}","off");
INSERT INTO `wp_options` VALUES("96","auto_update_core_dev","enabled","on");
INSERT INTO `wp_options` VALUES("97","auto_update_core_minor","enabled","on");
INSERT INTO `wp_options` VALUES("98","auto_update_core_major","enabled","on");
INSERT INTO `wp_options` VALUES("99","wp_force_deactivated_plugins","a:0:{}","on");
INSERT INTO `wp_options` VALUES("100","wp_attachment_pages_enabled","0","on");
INSERT INTO `wp_options` VALUES("101","initial_db_version","58975","on");
INSERT INTO `wp_options` VALUES("102","wp_user_roles","a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:62:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:20:\"wpseo_manage_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}","on");
INSERT INTO `wp_options` VALUES("103","fresh_site","0","off");
INSERT INTO `wp_options` VALUES("104","user_count","1","off");
INSERT INTO `wp_options` VALUES("105","widget_block","a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp_options` VALUES("106","sidebars_widgets","a:3:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:12:\"blog_sidebar\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:13:\"array_version\";i:3;}","auto");
INSERT INTO `wp_options` VALUES("107","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp_options` VALUES("108","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp_options` VALUES("109","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp_options` VALUES("110","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp_options` VALUES("111","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp_options` VALUES("112","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp_options` VALUES("113","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp_options` VALUES("114","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp_options` VALUES("115","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp_options` VALUES("116","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp_options` VALUES("117","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp_options` VALUES("118","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp_options` VALUES("119","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp_options` VALUES("120","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp_options` VALUES("121","_transient_wp_core_block_css_files","a:2:{s:7:\"version\";s:5:\"6.7.2\";s:5:\"files\";a:540:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:27:\"post-content/editor-rtl.css\";i:309;s:31:\"post-content/editor-rtl.min.css\";i:310;s:23:\"post-content/editor.css\";i:311;s:27:\"post-content/editor.min.css\";i:312;s:26:\"post-content/style-rtl.css\";i:313;s:30:\"post-content/style-rtl.min.css\";i:314;s:22:\"post-content/style.css\";i:315;s:26:\"post-content/style.min.css\";i:316;s:23:\"post-date/style-rtl.css\";i:317;s:27:\"post-date/style-rtl.min.css\";i:318;s:19:\"post-date/style.css\";i:319;s:23:\"post-date/style.min.css\";i:320;s:27:\"post-excerpt/editor-rtl.css\";i:321;s:31:\"post-excerpt/editor-rtl.min.css\";i:322;s:23:\"post-excerpt/editor.css\";i:323;s:27:\"post-excerpt/editor.min.css\";i:324;s:26:\"post-excerpt/style-rtl.css\";i:325;s:30:\"post-excerpt/style-rtl.min.css\";i:326;s:22:\"post-excerpt/style.css\";i:327;s:26:\"post-excerpt/style.min.css\";i:328;s:34:\"post-featured-image/editor-rtl.css\";i:329;s:38:\"post-featured-image/editor-rtl.min.css\";i:330;s:30:\"post-featured-image/editor.css\";i:331;s:34:\"post-featured-image/editor.min.css\";i:332;s:33:\"post-featured-image/style-rtl.css\";i:333;s:37:\"post-featured-image/style-rtl.min.css\";i:334;s:29:\"post-featured-image/style.css\";i:335;s:33:\"post-featured-image/style.min.css\";i:336;s:34:\"post-navigation-link/style-rtl.css\";i:337;s:38:\"post-navigation-link/style-rtl.min.css\";i:338;s:30:\"post-navigation-link/style.css\";i:339;s:34:\"post-navigation-link/style.min.css\";i:340;s:28:\"post-template/editor-rtl.css\";i:341;s:32:\"post-template/editor-rtl.min.css\";i:342;s:24:\"post-template/editor.css\";i:343;s:28:\"post-template/editor.min.css\";i:344;s:27:\"post-template/style-rtl.css\";i:345;s:31:\"post-template/style-rtl.min.css\";i:346;s:23:\"post-template/style.css\";i:347;s:27:\"post-template/style.min.css\";i:348;s:24:\"post-terms/style-rtl.css\";i:349;s:28:\"post-terms/style-rtl.min.css\";i:350;s:20:\"post-terms/style.css\";i:351;s:24:\"post-terms/style.min.css\";i:352;s:24:\"post-title/style-rtl.css\";i:353;s:28:\"post-title/style-rtl.min.css\";i:354;s:20:\"post-title/style.css\";i:355;s:24:\"post-title/style.min.css\";i:356;s:26:\"preformatted/style-rtl.css\";i:357;s:30:\"preformatted/style-rtl.min.css\";i:358;s:22:\"preformatted/style.css\";i:359;s:26:\"preformatted/style.min.css\";i:360;s:24:\"pullquote/editor-rtl.css\";i:361;s:28:\"pullquote/editor-rtl.min.css\";i:362;s:20:\"pullquote/editor.css\";i:363;s:24:\"pullquote/editor.min.css\";i:364;s:23:\"pullquote/style-rtl.css\";i:365;s:27:\"pullquote/style-rtl.min.css\";i:366;s:19:\"pullquote/style.css\";i:367;s:23:\"pullquote/style.min.css\";i:368;s:23:\"pullquote/theme-rtl.css\";i:369;s:27:\"pullquote/theme-rtl.min.css\";i:370;s:19:\"pullquote/theme.css\";i:371;s:23:\"pullquote/theme.min.css\";i:372;s:39:\"query-pagination-numbers/editor-rtl.css\";i:373;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:374;s:35:\"query-pagination-numbers/editor.css\";i:375;s:39:\"query-pagination-numbers/editor.min.css\";i:376;s:31:\"query-pagination/editor-rtl.css\";i:377;s:35:\"query-pagination/editor-rtl.min.css\";i:378;s:27:\"query-pagination/editor.css\";i:379;s:31:\"query-pagination/editor.min.css\";i:380;s:30:\"query-pagination/style-rtl.css\";i:381;s:34:\"query-pagination/style-rtl.min.css\";i:382;s:26:\"query-pagination/style.css\";i:383;s:30:\"query-pagination/style.min.css\";i:384;s:25:\"query-title/style-rtl.css\";i:385;s:29:\"query-title/style-rtl.min.css\";i:386;s:21:\"query-title/style.css\";i:387;s:25:\"query-title/style.min.css\";i:388;s:20:\"query/editor-rtl.css\";i:389;s:24:\"query/editor-rtl.min.css\";i:390;s:16:\"query/editor.css\";i:391;s:20:\"query/editor.min.css\";i:392;s:19:\"quote/style-rtl.css\";i:393;s:23:\"quote/style-rtl.min.css\";i:394;s:15:\"quote/style.css\";i:395;s:19:\"quote/style.min.css\";i:396;s:19:\"quote/theme-rtl.css\";i:397;s:23:\"quote/theme-rtl.min.css\";i:398;s:15:\"quote/theme.css\";i:399;s:19:\"quote/theme.min.css\";i:400;s:23:\"read-more/style-rtl.css\";i:401;s:27:\"read-more/style-rtl.min.css\";i:402;s:19:\"read-more/style.css\";i:403;s:23:\"read-more/style.min.css\";i:404;s:18:\"rss/editor-rtl.css\";i:405;s:22:\"rss/editor-rtl.min.css\";i:406;s:14:\"rss/editor.css\";i:407;s:18:\"rss/editor.min.css\";i:408;s:17:\"rss/style-rtl.css\";i:409;s:21:\"rss/style-rtl.min.css\";i:410;s:13:\"rss/style.css\";i:411;s:17:\"rss/style.min.css\";i:412;s:21:\"search/editor-rtl.css\";i:413;s:25:\"search/editor-rtl.min.css\";i:414;s:17:\"search/editor.css\";i:415;s:21:\"search/editor.min.css\";i:416;s:20:\"search/style-rtl.css\";i:417;s:24:\"search/style-rtl.min.css\";i:418;s:16:\"search/style.css\";i:419;s:20:\"search/style.min.css\";i:420;s:20:\"search/theme-rtl.css\";i:421;s:24:\"search/theme-rtl.min.css\";i:422;s:16:\"search/theme.css\";i:423;s:20:\"search/theme.min.css\";i:424;s:24:\"separator/editor-rtl.css\";i:425;s:28:\"separator/editor-rtl.min.css\";i:426;s:20:\"separator/editor.css\";i:427;s:24:\"separator/editor.min.css\";i:428;s:23:\"separator/style-rtl.css\";i:429;s:27:\"separator/style-rtl.min.css\";i:430;s:19:\"separator/style.css\";i:431;s:23:\"separator/style.min.css\";i:432;s:23:\"separator/theme-rtl.css\";i:433;s:27:\"separator/theme-rtl.min.css\";i:434;s:19:\"separator/theme.css\";i:435;s:23:\"separator/theme.min.css\";i:436;s:24:\"shortcode/editor-rtl.css\";i:437;s:28:\"shortcode/editor-rtl.min.css\";i:438;s:20:\"shortcode/editor.css\";i:439;s:24:\"shortcode/editor.min.css\";i:440;s:24:\"site-logo/editor-rtl.css\";i:441;s:28:\"site-logo/editor-rtl.min.css\";i:442;s:20:\"site-logo/editor.css\";i:443;s:24:\"site-logo/editor.min.css\";i:444;s:23:\"site-logo/style-rtl.css\";i:445;s:27:\"site-logo/style-rtl.min.css\";i:446;s:19:\"site-logo/style.css\";i:447;s:23:\"site-logo/style.min.css\";i:448;s:27:\"site-tagline/editor-rtl.css\";i:449;s:31:\"site-tagline/editor-rtl.min.css\";i:450;s:23:\"site-tagline/editor.css\";i:451;s:27:\"site-tagline/editor.min.css\";i:452;s:26:\"site-tagline/style-rtl.css\";i:453;s:30:\"site-tagline/style-rtl.min.css\";i:454;s:22:\"site-tagline/style.css\";i:455;s:26:\"site-tagline/style.min.css\";i:456;s:25:\"site-title/editor-rtl.css\";i:457;s:29:\"site-title/editor-rtl.min.css\";i:458;s:21:\"site-title/editor.css\";i:459;s:25:\"site-title/editor.min.css\";i:460;s:24:\"site-title/style-rtl.css\";i:461;s:28:\"site-title/style-rtl.min.css\";i:462;s:20:\"site-title/style.css\";i:463;s:24:\"site-title/style.min.css\";i:464;s:26:\"social-link/editor-rtl.css\";i:465;s:30:\"social-link/editor-rtl.min.css\";i:466;s:22:\"social-link/editor.css\";i:467;s:26:\"social-link/editor.min.css\";i:468;s:27:\"social-links/editor-rtl.css\";i:469;s:31:\"social-links/editor-rtl.min.css\";i:470;s:23:\"social-links/editor.css\";i:471;s:27:\"social-links/editor.min.css\";i:472;s:26:\"social-links/style-rtl.css\";i:473;s:30:\"social-links/style-rtl.min.css\";i:474;s:22:\"social-links/style.css\";i:475;s:26:\"social-links/style.min.css\";i:476;s:21:\"spacer/editor-rtl.css\";i:477;s:25:\"spacer/editor-rtl.min.css\";i:478;s:17:\"spacer/editor.css\";i:479;s:21:\"spacer/editor.min.css\";i:480;s:20:\"spacer/style-rtl.css\";i:481;s:24:\"spacer/style-rtl.min.css\";i:482;s:16:\"spacer/style.css\";i:483;s:20:\"spacer/style.min.css\";i:484;s:20:\"table/editor-rtl.css\";i:485;s:24:\"table/editor-rtl.min.css\";i:486;s:16:\"table/editor.css\";i:487;s:20:\"table/editor.min.css\";i:488;s:19:\"table/style-rtl.css\";i:489;s:23:\"table/style-rtl.min.css\";i:490;s:15:\"table/style.css\";i:491;s:19:\"table/style.min.css\";i:492;s:19:\"table/theme-rtl.css\";i:493;s:23:\"table/theme-rtl.min.css\";i:494;s:15:\"table/theme.css\";i:495;s:19:\"table/theme.min.css\";i:496;s:24:\"tag-cloud/editor-rtl.css\";i:497;s:28:\"tag-cloud/editor-rtl.min.css\";i:498;s:20:\"tag-cloud/editor.css\";i:499;s:24:\"tag-cloud/editor.min.css\";i:500;s:23:\"tag-cloud/style-rtl.css\";i:501;s:27:\"tag-cloud/style-rtl.min.css\";i:502;s:19:\"tag-cloud/style.css\";i:503;s:23:\"tag-cloud/style.min.css\";i:504;s:28:\"template-part/editor-rtl.css\";i:505;s:32:\"template-part/editor-rtl.min.css\";i:506;s:24:\"template-part/editor.css\";i:507;s:28:\"template-part/editor.min.css\";i:508;s:27:\"template-part/theme-rtl.css\";i:509;s:31:\"template-part/theme-rtl.min.css\";i:510;s:23:\"template-part/theme.css\";i:511;s:27:\"template-part/theme.min.css\";i:512;s:30:\"term-description/style-rtl.css\";i:513;s:34:\"term-description/style-rtl.min.css\";i:514;s:26:\"term-description/style.css\";i:515;s:30:\"term-description/style.min.css\";i:516;s:27:\"text-columns/editor-rtl.css\";i:517;s:31:\"text-columns/editor-rtl.min.css\";i:518;s:23:\"text-columns/editor.css\";i:519;s:27:\"text-columns/editor.min.css\";i:520;s:26:\"text-columns/style-rtl.css\";i:521;s:30:\"text-columns/style-rtl.min.css\";i:522;s:22:\"text-columns/style.css\";i:523;s:26:\"text-columns/style.min.css\";i:524;s:19:\"verse/style-rtl.css\";i:525;s:23:\"verse/style-rtl.min.css\";i:526;s:15:\"verse/style.css\";i:527;s:19:\"verse/style.min.css\";i:528;s:20:\"video/editor-rtl.css\";i:529;s:24:\"video/editor-rtl.min.css\";i:530;s:16:\"video/editor.css\";i:531;s:20:\"video/editor.min.css\";i:532;s:19:\"video/style-rtl.css\";i:533;s:23:\"video/style-rtl.min.css\";i:534;s:15:\"video/style.css\";i:535;s:19:\"video/style.min.css\";i:536;s:19:\"video/theme-rtl.css\";i:537;s:23:\"video/theme-rtl.min.css\";i:538;s:15:\"video/theme.css\";i:539;s:19:\"video/theme.min.css\";}}","on");
INSERT INTO `wp_options` VALUES("125","recovery_keys","a:0:{}","off");
INSERT INTO `wp_options` VALUES("126","theme_mods_twentytwentyfive","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1765117598;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}","off");
INSERT INTO `wp_options` VALUES("127","_transient_wp_styles_for_blocks","a:2:{s:4:\"hash\";s:32:\"8c7d46a72d7d4591fc1dd9485bedb304\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}","on");
INSERT INTO `wp_options` VALUES("129","current_theme","WMD Theme","auto");
INSERT INTO `wp_options` VALUES("130","theme_switched","","auto");
INSERT INTO `wp_options` VALUES("131","yoast_migrations_free","a:1:{s:7:\"version\";s:4:\"24.2\";}","auto");
INSERT INTO `wp_options` VALUES("132","wpseo","a:105:{s:8:\"tracking\";b:0;s:16:\"toggled_tracking\";b:0;s:22:\"license_server_version\";i:2;s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:19:\"indexing_first_time\";b:1;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:0:\"\";s:29:\"indexables_indexing_completed\";b:0;s:13:\"index_now_key\";s:0:\"\";s:7:\"version\";s:4:\"24.2\";s:16:\"previous_version\";s:0:\"\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:0;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:34:\"inclusive_language_analysis_active\";b:0;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:16:\"enable_index_now\";b:1;s:19:\"enable_ai_generator\";b:1;s:22:\"ai_enabled_pre_default\";b:0;s:22:\"show_onboarding_notice\";b:0;s:18:\"first_activated_on\";b:0;s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:23:\"/%category%/%postname%/\";s:8:\"home_url\";s:41:\"http://peka777.net\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:0:{}s:29:\"enable_enhanced_slack_sharing\";b:1;s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;s:14:\"import_cursors\";a:0:{}s:13:\"workouts_data\";a:1:{s:13:\"configuration\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:28:\"configuration_finished_steps\";a:0:{}s:36:\"dismiss_configuration_workout_notice\";b:0;s:34:\"dismiss_premium_deactivated_notice\";b:0;s:19:\"importing_completed\";a:0:{}s:26:\"wincher_integration_active\";b:1;s:14:\"wincher_tokens\";a:0:{}s:36:\"wincher_automatically_add_keyphrases\";b:0;s:18:\"wincher_website_id\";s:0:\"\";s:18:\"first_time_install\";b:0;s:34:\"should_redirect_after_install_free\";b:0;s:34:\"activation_redirect_timestamp_free\";i:1652258756;s:18:\"remove_feed_global\";b:0;s:27:\"remove_feed_global_comments\";b:0;s:25:\"remove_feed_post_comments\";b:0;s:19:\"remove_feed_authors\";b:0;s:22:\"remove_feed_categories\";b:0;s:16:\"remove_feed_tags\";b:0;s:29:\"remove_feed_custom_taxonomies\";b:0;s:22:\"remove_feed_post_types\";b:0;s:18:\"remove_feed_search\";b:0;s:21:\"remove_atom_rdf_feeds\";b:0;s:17:\"remove_shortlinks\";b:0;s:21:\"remove_rest_api_links\";b:0;s:20:\"remove_rsd_wlw_links\";b:0;s:19:\"remove_oembed_links\";b:0;s:16:\"remove_generator\";b:0;s:20:\"remove_emoji_scripts\";b:0;s:24:\"remove_powered_by_header\";b:0;s:22:\"remove_pingback_header\";b:0;s:28:\"clean_campaign_tracking_urls\";b:0;s:16:\"clean_permalinks\";b:0;s:32:\"clean_permalinks_extra_variables\";s:0:\"\";s:14:\"search_cleanup\";b:0;s:20:\"search_cleanup_emoji\";b:0;s:23:\"search_cleanup_patterns\";b:0;s:22:\"search_character_limit\";i:50;s:20:\"deny_search_crawling\";b:0;s:21:\"deny_wp_json_crawling\";b:0;s:20:\"deny_adsbot_crawling\";b:0;s:19:\"deny_ccbot_crawling\";b:0;s:29:\"deny_google_extended_crawling\";b:0;s:20:\"deny_gptbot_crawling\";b:0;s:27:\"redirect_search_pretty_urls\";b:0;s:29:\"least_readability_ignore_list\";a:0:{}s:27:\"least_seo_score_ignore_list\";a:0:{}s:23:\"most_linked_ignore_list\";a:0:{}s:24:\"least_linked_ignore_list\";a:0:{}s:28:\"indexables_page_reading_list\";a:5:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;}s:25:\"indexables_overview_state\";s:21:\"dashboard-not-visited\";s:28:\"last_known_public_post_types\";a:0:{}s:28:\"last_known_public_taxonomies\";a:0:{}s:23:\"last_known_no_unindexed\";a:0:{}s:14:\"new_post_types\";a:0:{}s:14:\"new_taxonomies\";a:0:{}s:34:\"show_new_content_type_notification\";b:0;}","auto");
INSERT INTO `wp_options` VALUES("133","wpseo_titles","a:129:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:1;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:2:\"»\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:22:\"company_alternate_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:24:\"publishing_principles_id\";i:0;s:25:\"ownership_funding_info_id\";i:0;s:29:\"actionable_feedback_policy_id\";i:0;s:21:\"corrections_policy_id\";i:0;s:16:\"ethics_policy_id\";i:0;s:19:\"diversity_policy_id\";i:0;s:28:\"diversity_staffing_report_id\";i:0;s:15:\"org-description\";s:0:\"\";s:9:\"org-email\";s:0:\"\";s:9:\"org-phone\";s:0:\"\";s:14:\"org-legal-name\";s:0:\"\";s:17:\"org-founding-date\";s:0:\"\";s:20:\"org-number-employees\";s:0:\"\";s:10:\"org-vat-id\";s:0:\"\";s:10:\"org-tax-id\";s:0:\"\";s:7:\"org-iso\";s:0:\"\";s:8:\"org-duns\";s:0:\"\";s:11:\"org-leicode\";s:0:\"\";s:9:\"org-naics\";s:0:\"\";s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:25:\"social-title-tax-category\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:26:\"taxonomy-category-ptparent\";i:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:25:\"social-title-tax-post_tag\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:26:\"taxonomy-post_tag-ptparent\";i:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:23:\"%%term_title%% Archives\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:29:\"taxonomy-post_format-ptparent\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:0;s:17:\"company_logo_meta\";b:0;s:16:\"person_logo_meta\";b:0;s:29:\"open_graph_frontpage_image_id\";i:0;}","auto");
INSERT INTO `wp_options` VALUES("134","wpseo_social","a:20:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";s:17:\"other_social_urls\";a:0:{}s:12:\"mastodon_url\";s:0:\"\";}","auto");
INSERT INTO `wp_options` VALUES("138","_transient_timeout_wpseo_total_unindexed_posts_limited","1765118542","off");
INSERT INTO `wp_options` VALUES("139","_transient_wpseo_total_unindexed_posts_limited","2","off");
INSERT INTO `wp_options` VALUES("140","theme_mods_mgz9rgj2nkn8ysxvapb2q499386","a:3:{s:18:\"nav_menu_locations\";a:0:{}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1765117810;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:12:\"blog_sidebar\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}}}s:18:\"custom_css_post_id\";i:-1;}","off");
INSERT INTO `wp_options` VALUES("154","_site_transient_timeout_wp_theme_files_patterns-e9e6a5fbec8e807db3d0a8e01b9c5395","1765119619","off");
INSERT INTO `wp_options` VALUES("155","_site_transient_wp_theme_files_patterns-e9e6a5fbec8e807db3d0a8e01b9c5395","a:2:{s:7:\"version\";s:0:\"\";s:8:\"patterns\";a:0:{}}","off");



DROP TABLE IF EXISTS `wp_postmeta`;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `wp_postmeta` VALUES("1","1","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("2","1","_yoast_wpseo_title","Peka777 : Daftar 1 ID Game Anda Bisa Menikmati Fitur Selamanya");
INSERT INTO `wp_postmeta` VALUES("3","1","_yoast_wpseo_metadesc","Peka777 Dengan semua game mobile favorit dalam satu ID, tidak hanya memperluas pengalaman, tetapi menikmati fitur ekslusif Peka 777.");
INSERT INTO `wp_postmeta` VALUES("4","2","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("5","2","custom_permalink","author/admin.html");
INSERT INTO `wp_postmeta` VALUES("6","2","_yoast_wpseo_title","Admin, Pengarang di Peka777");
INSERT INTO `wp_postmeta` VALUES("7","3","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("8","3","custom_permalink","category/uncategorized.html");
INSERT INTO `wp_postmeta` VALUES("9","3","_yoast_wpseo_title","Peka777 Arsip : Peka777");
INSERT INTO `wp_postmeta` VALUES("10","4","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("11","4","custom_permalink","link-alternatif-peka777.html");
INSERT INTO `wp_postmeta` VALUES("12","4","_yoast_wpseo_title","Link Alternatif Peka777 : Keuntungan Besar Game Spin Online Kami");
INSERT INTO `wp_postmeta` VALUES("13","4","_yoast_wpseo_metadesc","Link Alternatif Peka777 merupakan prize pool agen game terbaik dengan sensasi kemenangan dan nikmati peluang besar meraih hadiah spektakuler.");
INSERT INTO `wp_postmeta` VALUES("14","5","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("15","5","custom_permalink","peka777-alternatif.html");
INSERT INTO `wp_postmeta` VALUES("16","5","_yoast_wpseo_title","Peka777 Alternatif : Situs Game Top Reward Terpercaya benefit");
INSERT INTO `wp_postmeta` VALUES("17","5","_yoast_wpseo_metadesc","Peka777 Alternatif merupakan situs game online dengan reward besar yang terpercaya, memberikan berbagai benefit tinggi setiap harinya.");
INSERT INTO `wp_postmeta` VALUES("18","6","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("19","6","custom_permalink","peka777-daftar.html");
INSERT INTO `wp_postmeta` VALUES("20","6","_yoast_wpseo_title","Peka777 Daftar : Situs Game Top Reward Besar Terpercaya benefit");
INSERT INTO `wp_postmeta` VALUES("21","6","_yoast_wpseo_metadesc","Peka777 Daftar merupakan situs game online populer dengan reward besar yang terpercaya, memberikan berbagai benefit tinggi setiap harinya.");
INSERT INTO `wp_postmeta` VALUES("22","7","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("23","7","custom_permalink","peka777-dana.html");
INSERT INTO `wp_postmeta` VALUES("24","7","_yoast_wpseo_title","Peka777 Dana : Hadiahi Diri Dengan Iphone 16, Main Gacor Hari Ini");
INSERT INTO `wp_postmeta` VALUES("25","7","_yoast_wpseo_metadesc","Peka777 Dana Main gacor dan menangkan hadiah mewah seperti iPhone 16 dan hadiah menarik lainnya. Peluang kemenangan yang lebih besar.");
INSERT INTO `wp_postmeta` VALUES("26","8","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("27","8","custom_permalink","peka777-deposit-dana.html");
INSERT INTO `wp_postmeta` VALUES("28","8","_yoast_wpseo_title","Peka777 Deposit Dana : Taruhan Aman Dengan Pola Maxwin");
INSERT INTO `wp_postmeta` VALUES("29","8","_yoast_wpseo_metadesc","Peka777 Deposit Dana Menang maksimal dengan taruhan aman dan pola maxwin. Raih jackpot besar dengan percaya diri dapatkan bonus besarnya.");
INSERT INTO `wp_postmeta` VALUES("30","9","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("31","9","custom_permalink","peka777-download.html");
INSERT INTO `wp_postmeta` VALUES("32","9","_yoast_wpseo_title","Peka777 Download : Favorite Terbaik Game Cuan Online Terpopuler");
INSERT INTO `wp_postmeta` VALUES("33","9","_yoast_wpseo_metadesc","Peka777 Download adalah favorite games terbaik dalam game online yang terpopuler dalam kenyamanan bermain dan nikmati pengalaman tiap hari.");
INSERT INTO `wp_postmeta` VALUES("34","10","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("35","10","custom_permalink","peka777-hoki.html");
INSERT INTO `wp_postmeta` VALUES("36","10","_yoast_wpseo_title","Peka777 Hoki : Menjelajahi Dunia Olahraga Keyakinan");
INSERT INTO `wp_postmeta` VALUES("37","10","_yoast_wpseo_metadesc","Peka777 Hoki ikuti turnamen dan kompetisi situs-situs game terbaik yang menjanjikan hadiah besar dan ketenaran bagi pemenangnya.");
INSERT INTO `wp_postmeta` VALUES("38","11","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("39","11","custom_permalink","peka777-link-alternatif.html");
INSERT INTO `wp_postmeta` VALUES("40","11","_yoast_wpseo_title","Peka777 Link Alternatif : Keuntungan Besar Game Spin Online Kami");
INSERT INTO `wp_postmeta` VALUES("41","11","_yoast_wpseo_metadesc","Peka777 Link Alternatif merupakan keuntungan besar setiap hari dalam game online kami dalam tinggi dan raih hadiah-hadiah menarik sekali.");
INSERT INTO `wp_postmeta` VALUES("42","12","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("43","12","custom_permalink","peka777-login.html");
INSERT INTO `wp_postmeta` VALUES("44","12","_yoast_wpseo_title","Peka777 Login : Best Games Online Big Win Populer Dan Terbaik");
INSERT INTO `wp_postmeta` VALUES("45","12","_yoast_wpseo_metadesc","Peka777 Login merupakan best games online dengan Reward yang populer dan terbaik dalam pengalaman dan raih peluang besar meraih kemenangan.");
INSERT INTO `wp_postmeta` VALUES("46","13","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("47","13","custom_permalink","peka777-pulsa.html");
INSERT INTO `wp_postmeta` VALUES("48","13","_yoast_wpseo_title","Peka777 Pulsa : Menjelajahi Dunia Olahraga Keyakinan");
INSERT INTO `wp_postmeta` VALUES("49","13","_yoast_wpseo_metadesc","Peka777 Pulsa ikuti turnamen dan kompetisi situs-situs game terbaik yang menjanjikan hadiah besar dan ketenaran bagi pemenangnya.");
INSERT INTO `wp_postmeta` VALUES("50","14","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("51","14","custom_permalink","peka777-register.html");
INSERT INTO `wp_postmeta` VALUES("52","14","_yoast_wpseo_title","Peka777 Register : Favorite Games Terbaik Game Online Terpopuler");
INSERT INTO `wp_postmeta` VALUES("53","14","_yoast_wpseo_metadesc","Peka777 Register adalah favorite games terbaik dalam game online yang terpopuler dalam kenyamanan bermain dan nikmati pengalaman tiap hari.");
INSERT INTO `wp_postmeta` VALUES("54","15","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("55","15","custom_permalink","peka777-slot-login.html");
INSERT INTO `wp_postmeta` VALUES("56","15","_yoast_wpseo_title","Peka777 Slot Login : Keuntungan Pemain Sangat Untung");
INSERT INTO `wp_postmeta` VALUES("57","15","_yoast_wpseo_metadesc","Peka777 Slot Login temukan situs-situs terbaik yang pasar Asia dengan grafis yang memukau dan peluang penghasilan melimpah.");



DROP TABLE IF EXISTS `wp_posts`;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `wp_posts` VALUES("1","0","2025-12-07 14:30:10","2025-12-07 14:30:10","<div class=\"main\">
                <div class=\"slide\">
                    <div class=\"row\">
                        <div class=\"main-slide col-sm-12\">
                            <amp-img alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\" width=\"1920\" height=\"613\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\"></amp-img>
                        </div>
                    </div>
                </div>
                <div class=\"menu-mobile mobile\">
                    <div class=\"container\">
                        <div class=\"row\">
                            <div class=\"col-sm-12\">
                                <div class=\"menu-login-menu-container\">
                                    <ul id=\"menu-login-menu-1\" class=\"login-mobile\">
                                        <li class=\"daftar menu-item menu-item-type-custom menu-item-object-custom menu-item-20\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/SatelitMabarr88\">Daftar</a></li>
<li class=\"login menu-item menu-item-type-custom menu-item-object-custom menu-item-21\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/Mabar88\">Login</a></li>
</ul>
                                </div>
                                <div class=\"menu-main-homepage-container\">
                                    <ul id=\"menu-main-homepage\" class=\"main-homepage\">
                                        <li id=\"menu-item-84\" class=\"menu-item menu-item-type-post_type menu-item-object-page menu-item-home current-menu-item page_item page-item-2 current_page_item menu-item-84\"><a href=\"[get_bloginfo]url[/get_bloginfo]\" aria-current=\"page\"><i class=\"svg-beranda svg-menu\"></i> Home</a></li>
                                        <li id=\"menu-item-29\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-29\"><a href=\"#\"><i class=\"svg-hot svg-menu\"></i> Hot Games</a></li>
                                        <li id=\"menu-item-30\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-30\"><a href=\"#\"><i class=\"svg-slots svg-menu\"></i> Slots</a></li>
                                        <li id=\"menu-item-31\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-31\"><a href=\"#\"><i class=\"svg-casino svg-menu\"></i> Live Casino</a></li>
                                        <li id=\"menu-item-36\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-36\"><a href=\"#\"><i class=\"svg-sport svg-menu\"></i> Sports</a></li>
                                        <li id=\"menu-item-81\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-81\"><a href=\"#\"><i class=\"svg-fishing svg-menu\"></i> Arcade</a></li>
                                        <li id=\"menu-item-82\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-82\"><a href=\"#\"><i class=\"svg-poker svg-menu\"></i> Poker</a></li>
                                        <li id=\"menu-item-83\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-83\"><a href=\"#\"><i class=\"svg-togel svg-menu\"></i> Togel Online</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class=\"bg-rounded\">
                    <div class=\"container\">
                        <div class=\"jackpot\">
                            <div class=\"row\">
                                <div class=\"col-sm-12\">
                                    <amp-anim alt=\"Jackpot Slot\" src=\"https://peka777.net/wp-content/themes/mabar88/images/tips-menang.webp\" width=\"640\" height=\"183\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                    </amp-anim>
                                </div>
                            </div>
                        </div>
                        <div class=\"games\">
                            <div class=\"title-row col-sm-12\"><i class=\"svg-gacor svg-content\"></i> Best Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Mahjong Wins 3</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Almighty Zeus Wilds™</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Twins Nexus</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Gods</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">SixSixSix</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Beam Boys</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-new svg-content\"></i> Daily Wins</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">5 Lions Megaways</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Emperor Caishen</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Release the Kraken 2</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wisdom of Athena</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Aztec Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rujak Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-populer svg-content\"></i> Hot Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Neko</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Tiger</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Treasures of Aztec</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wild Bandito</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Dreams of Macau</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rooster Rumble</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
                <div class=\"disclaimer\">
                    <div class=\"container\">
                        <div class=\"article\" id=\"post-2\">
                            <div id=\"post-18\">
                                <h1 data-amp-original-style=\"text-align: center;\" class=\"amp-wp-cdd8ca0\"><strong>Peka777 : Daftar 1 ID Game Anda Bisa Menikmati Fitur Selamanya</strong></h1>
                            </div>
                        </div>
                    </div>
                </div>","Home","","publish","closed","closed","","home","","","2025-12-07 14:30:10","2025-12-07 14:30:10","","0","http://peka777.net/","0","page","","0");
INSERT INTO `wp_posts` VALUES("2","0","2025-12-07 14:30:11","2025-12-07 14:30:11","<div class=\"main\">
                <div class=\"slide\">
                    <div class=\"row\">
                        <div class=\"main-slide col-sm-12\">
                            <amp-img alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\" width=\"1920\" height=\"613\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\"></amp-img>
                        </div>
                    </div>
                </div>
                <div class=\"menu-mobile mobile\">
                    <div class=\"container\">
                        <div class=\"row\">
                            <div class=\"col-sm-12\">
                                <div class=\"menu-login-menu-container\">
                                    <ul id=\"menu-login-menu-1\" class=\"login-mobile\">
                                        <li class=\"daftar menu-item menu-item-type-custom menu-item-object-custom menu-item-20\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/SatelitMabarr88\">Daftar</a></li>
<li class=\"login menu-item menu-item-type-custom menu-item-object-custom menu-item-21\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/Mabar88\">Login</a></li>
</ul>
                                </div>
                                <div class=\"menu-main-homepage-container\">
                                    <ul id=\"menu-main-homepage\" class=\"main-homepage\">
                                        <li id=\"menu-item-84\" class=\"menu-item menu-item-type-post_type menu-item-object-page menu-item-home current-menu-item page_item page-item-2 current_page_item menu-item-84\"><a href=\"[get_bloginfo]url[/get_bloginfo]\" aria-current=\"page\"><i class=\"svg-beranda svg-menu\"></i> Home</a></li>
                                        <li id=\"menu-item-29\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-29\"><a href=\"#\"><i class=\"svg-hot svg-menu\"></i> Hot Games</a></li>
                                        <li id=\"menu-item-30\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-30\"><a href=\"#\"><i class=\"svg-slots svg-menu\"></i> Slots</a></li>
                                        <li id=\"menu-item-31\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-31\"><a href=\"#\"><i class=\"svg-casino svg-menu\"></i> Live Casino</a></li>
                                        <li id=\"menu-item-36\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-36\"><a href=\"#\"><i class=\"svg-sport svg-menu\"></i> Sports</a></li>
                                        <li id=\"menu-item-81\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-81\"><a href=\"#\"><i class=\"svg-fishing svg-menu\"></i> Arcade</a></li>
                                        <li id=\"menu-item-82\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-82\"><a href=\"#\"><i class=\"svg-poker svg-menu\"></i> Poker</a></li>
                                        <li id=\"menu-item-83\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-83\"><a href=\"#\"><i class=\"svg-togel svg-menu\"></i> Togel Online</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class=\"bg-rounded\">
                    <div class=\"container\">
                        <div class=\"jackpot\">
                            <div class=\"row\">
                                <div class=\"col-sm-12\">
                                    <amp-anim alt=\"Jackpot Slot\" src=\"https://peka777.net/wp-content/themes/mabar88/images/tips-menang.webp\" width=\"640\" height=\"183\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                    </amp-anim>
                                </div>
                            </div>
                        </div>
                        <div class=\"games\">
                            <div class=\"title-row col-sm-12\"><i class=\"svg-gacor svg-content\"></i> Best Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Mahjong Wins 3</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Almighty Zeus Wilds™</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Twins Nexus</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Gods</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">SixSixSix</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Beam Boys</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-new svg-content\"></i> Daily Wins</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">5 Lions Megaways</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Emperor Caishen</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Release the Kraken 2</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wisdom of Athena</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Aztec Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rujak Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-populer svg-content\"></i> Hot Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Neko</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Tiger</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Treasures of Aztec</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wild Bandito</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Dreams of Macau</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rooster Rumble</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
                <div class=\"disclaimer\">
                    <div class=\"container\">
                        <div class=\"article\" id=\"post-2\">
                            <div id=\"post-98\">
                                <h1 data-amp-original-style=\"text-align: center;\" class=\"amp-wp-cdd8ca0\"><strong>Peka777 Deposit Dana : Taruhan Aman Dengan Pola Maxwin</strong></h1>
                            </div>
                        </div>
                    </div>
                </div>","Peka777 Deposit Dana : Taruhan Aman Dengan Pola Maxwin","","publish","closed","closed","","peka777-deposit-dana-taruhan-aman-dengan-pola-maxwin","","","2025-12-07 14:30:11","2025-12-07 14:30:11","","0","http://peka777.net/peka777-deposit-dana-taruhan-aman-dengan-pola-maxwin/","0","page","","0");
INSERT INTO `wp_posts` VALUES("3","0","2025-12-07 14:30:11","2025-12-07 14:30:11","<div class=\"main\">
                <div class=\"slide\">
                    <div class=\"row\">
                        <div class=\"main-slide col-sm-12\">
                            <amp-img alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\" width=\"1920\" height=\"613\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\"></amp-img>
                        </div>
                    </div>
                </div>
                <div class=\"menu-mobile mobile\">
                    <div class=\"container\">
                        <div class=\"row\">
                            <div class=\"col-sm-12\">
                                <div class=\"menu-login-menu-container\">
                                    <ul id=\"menu-login-menu-1\" class=\"login-mobile\">
                                        <li class=\"daftar menu-item menu-item-type-custom menu-item-object-custom menu-item-20\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/SatelitMabarr88\">Daftar</a></li>
<li class=\"login menu-item menu-item-type-custom menu-item-object-custom menu-item-21\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/Mabar88\">Login</a></li>
</ul>
                                </div>
                                <div class=\"menu-main-homepage-container\">
                                    <ul id=\"menu-main-homepage\" class=\"main-homepage\">
                                        <li id=\"menu-item-84\" class=\"menu-item menu-item-type-post_type menu-item-object-page menu-item-home current-menu-item page_item page-item-2 current_page_item menu-item-84\"><a href=\"[get_bloginfo]url[/get_bloginfo]\" aria-current=\"page\"><i class=\"svg-beranda svg-menu\"></i> Home</a></li>
                                        <li id=\"menu-item-29\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-29\"><a href=\"#\"><i class=\"svg-hot svg-menu\"></i> Hot Games</a></li>
                                        <li id=\"menu-item-30\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-30\"><a href=\"#\"><i class=\"svg-slots svg-menu\"></i> Slots</a></li>
                                        <li id=\"menu-item-31\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-31\"><a href=\"#\"><i class=\"svg-casino svg-menu\"></i> Live Casino</a></li>
                                        <li id=\"menu-item-36\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-36\"><a href=\"#\"><i class=\"svg-sport svg-menu\"></i> Sports</a></li>
                                        <li id=\"menu-item-81\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-81\"><a href=\"#\"><i class=\"svg-fishing svg-menu\"></i> Arcade</a></li>
                                        <li id=\"menu-item-82\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-82\"><a href=\"#\"><i class=\"svg-poker svg-menu\"></i> Poker</a></li>
                                        <li id=\"menu-item-83\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-83\"><a href=\"#\"><i class=\"svg-togel svg-menu\"></i> Togel Online</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class=\"bg-rounded\">
                    <div class=\"container\">
                        <div class=\"jackpot\">
                            <div class=\"row\">
                                <div class=\"col-sm-12\">
                                    <amp-anim alt=\"Jackpot Slot\" src=\"https://peka777.net/wp-content/themes/mabar88/images/tips-menang.webp\" width=\"640\" height=\"183\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                    </amp-anim>
                                </div>
                            </div>
                        </div>
                        <div class=\"games\">
                            <div class=\"title-row col-sm-12\"><i class=\"svg-gacor svg-content\"></i> Best Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Mahjong Wins 3</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Almighty Zeus Wilds™</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Twins Nexus</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Gods</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">SixSixSix</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Beam Boys</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-new svg-content\"></i> Daily Wins</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">5 Lions Megaways</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Emperor Caishen</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Release the Kraken 2</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wisdom of Athena</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Aztec Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rujak Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-populer svg-content\"></i> Hot Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Neko</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Tiger</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Treasures of Aztec</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wild Bandito</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Dreams of Macau</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rooster Rumble</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
                <div class=\"disclaimer\">
                    <div class=\"container\">
                        <div class=\"article\" id=\"post-2\">
                            <div id=\"post-98\">
                                <h1 data-amp-original-style=\"text-align: center;\" class=\"amp-wp-cdd8ca0\"><strong>Peka777 Deposit Dana : Taruhan Aman Dengan Pola Maxwin</strong></h1>
                            </div>
                        </div>
                    </div>
                </div>","Peka777 Deposit Dana : Taruhan Aman Dengan Pola Maxwin","","publish","closed","closed","","peka777-deposit-dana-taruhan-aman-dengan-pola-maxwin-2","","","2025-12-07 14:30:11","2025-12-07 14:30:11","","0","http://peka777.net/peka777-deposit-dana-taruhan-aman-dengan-pola-maxwin-2/","0","page","","0");
INSERT INTO `wp_posts` VALUES("4","0","2025-12-07 14:30:11","2025-12-07 14:30:11","<div class=\"main\">
                <div class=\"slide\">
                    <div class=\"row\">
                        <div class=\"main-slide col-sm-12\">
                            <amp-img alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\" width=\"1920\" height=\"613\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\"></amp-img>
                        </div>
                    </div>
                </div>
                <div class=\"menu-mobile mobile\">
                    <div class=\"container\">
                        <div class=\"row\">
                            <div class=\"col-sm-12\">
                                <div class=\"menu-login-menu-container\">
                                    <ul id=\"menu-login-menu-1\" class=\"login-mobile\">
                                        <li class=\"daftar menu-item menu-item-type-custom menu-item-object-custom menu-item-20\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/SatelitMabarr88\">Daftar</a></li>
<li class=\"login menu-item menu-item-type-custom menu-item-object-custom menu-item-21\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/Mabar88\">Login</a></li>
</ul>
                                </div>
                                <div class=\"menu-main-homepage-container\">
                                    <ul id=\"menu-main-homepage\" class=\"main-homepage\">
                                        <li id=\"menu-item-84\" class=\"menu-item menu-item-type-post_type menu-item-object-page menu-item-home current-menu-item page_item page-item-2 current_page_item menu-item-84\"><a href=\"[get_bloginfo]url[/get_bloginfo]\" aria-current=\"page\"><i class=\"svg-beranda svg-menu\"></i> Home</a></li>
                                        <li id=\"menu-item-29\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-29\"><a href=\"#\"><i class=\"svg-hot svg-menu\"></i> Hot Games</a></li>
                                        <li id=\"menu-item-30\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-30\"><a href=\"#\"><i class=\"svg-slots svg-menu\"></i> Slots</a></li>
                                        <li id=\"menu-item-31\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-31\"><a href=\"#\"><i class=\"svg-casino svg-menu\"></i> Live Casino</a></li>
                                        <li id=\"menu-item-36\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-36\"><a href=\"#\"><i class=\"svg-sport svg-menu\"></i> Sports</a></li>
                                        <li id=\"menu-item-81\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-81\"><a href=\"#\"><i class=\"svg-fishing svg-menu\"></i> Arcade</a></li>
                                        <li id=\"menu-item-82\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-82\"><a href=\"#\"><i class=\"svg-poker svg-menu\"></i> Poker</a></li>
                                        <li id=\"menu-item-83\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-83\"><a href=\"#\"><i class=\"svg-togel svg-menu\"></i> Togel Online</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class=\"bg-rounded\">
                    <div class=\"container\">
                        <div class=\"jackpot\">
                            <div class=\"row\">
                                <div class=\"col-sm-12\">
                                    <amp-anim alt=\"Jackpot Slot\" src=\"https://peka777.net/wp-content/themes/mabar88/images/tips-menang.webp\" width=\"640\" height=\"183\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                    </amp-anim>
                                </div>
                            </div>
                        </div>
                        <div class=\"games\">
                            <div class=\"title-row col-sm-12\"><i class=\"svg-gacor svg-content\"></i> Best Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Mahjong Wins 3</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Almighty Zeus Wilds™</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Twins Nexus</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Gods</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">SixSixSix</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Beam Boys</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-new svg-content\"></i> Daily Wins</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">5 Lions Megaways</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Emperor Caishen</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Release the Kraken 2</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wisdom of Athena</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Aztec Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rujak Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-populer svg-content\"></i> Hot Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Neko</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Tiger</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Treasures of Aztec</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wild Bandito</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Dreams of Macau</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rooster Rumble</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
                <div class=\"disclaimer\">
                    <div class=\"container\">
                        <div class=\"article\" id=\"post-2\">
                            <div id=\"post-37\">
                                <h1 data-amp-original-style=\"text-align: center;\" class=\"amp-wp-cdd8ca0\"><strong>Link Alternatif Peka777 : Keuntungan Besar Game Spin Online Kami</strong></h1>
                            </div>
                        </div>
                    </div>
                </div>","Link Alternatif Peka777 : Keuntungan Besar Game Spin Online Kami","","publish","closed","closed","","link-alternatif-peka777-keuntungan-besar-game-spin-online-kami","","","2025-12-07 14:30:11","2025-12-07 14:30:11","","0","http://peka777.net/link-alternatif-peka777-keuntungan-besar-game-spin-online-kami/","0","page","","0");
INSERT INTO `wp_posts` VALUES("5","0","2025-12-07 14:30:11","2025-12-07 14:30:11","<div class=\"main\">
                <div class=\"slide\">
                    <div class=\"row\">
                        <div class=\"main-slide col-sm-12\">
                            <amp-img alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\" width=\"1920\" height=\"613\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\"></amp-img>
                        </div>
                    </div>
                </div>
                <div class=\"menu-mobile mobile\">
                    <div class=\"container\">
                        <div class=\"row\">
                            <div class=\"col-sm-12\">
                                <div class=\"menu-login-menu-container\">
                                    <ul id=\"menu-login-menu-1\" class=\"login-mobile\">
                                        <li class=\"daftar menu-item menu-item-type-custom menu-item-object-custom menu-item-20\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/SatelitMabarr88\">Daftar</a></li>
<li class=\"login menu-item menu-item-type-custom menu-item-object-custom menu-item-21\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/Mabar88\">Login</a></li>
</ul>
                                </div>
                                <div class=\"menu-main-homepage-container\">
                                    <ul id=\"menu-main-homepage\" class=\"main-homepage\">
                                        <li id=\"menu-item-84\" class=\"menu-item menu-item-type-post_type menu-item-object-page menu-item-home current-menu-item page_item page-item-2 current_page_item menu-item-84\"><a href=\"[get_bloginfo]url[/get_bloginfo]\" aria-current=\"page\"><i class=\"svg-beranda svg-menu\"></i> Home</a></li>
                                        <li id=\"menu-item-29\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-29\"><a href=\"#\"><i class=\"svg-hot svg-menu\"></i> Hot Games</a></li>
                                        <li id=\"menu-item-30\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-30\"><a href=\"#\"><i class=\"svg-slots svg-menu\"></i> Slots</a></li>
                                        <li id=\"menu-item-31\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-31\"><a href=\"#\"><i class=\"svg-casino svg-menu\"></i> Live Casino</a></li>
                                        <li id=\"menu-item-36\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-36\"><a href=\"#\"><i class=\"svg-sport svg-menu\"></i> Sports</a></li>
                                        <li id=\"menu-item-81\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-81\"><a href=\"#\"><i class=\"svg-fishing svg-menu\"></i> Arcade</a></li>
                                        <li id=\"menu-item-82\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-82\"><a href=\"#\"><i class=\"svg-poker svg-menu\"></i> Poker</a></li>
                                        <li id=\"menu-item-83\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-83\"><a href=\"#\"><i class=\"svg-togel svg-menu\"></i> Togel Online</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class=\"bg-rounded\">
                    <div class=\"container\">
                        <div class=\"jackpot\">
                            <div class=\"row\">
                                <div class=\"col-sm-12\">
                                    <amp-anim alt=\"Jackpot Slot\" src=\"https://peka777.net/wp-content/themes/mabar88/images/tips-menang.webp\" width=\"640\" height=\"183\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                    </amp-anim>
                                </div>
                            </div>
                        </div>
                        <div class=\"games\">
                            <div class=\"title-row col-sm-12\"><i class=\"svg-gacor svg-content\"></i> Best Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Mahjong Wins 3</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Almighty Zeus Wilds™</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Twins Nexus</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Gods</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">SixSixSix</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Beam Boys</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-new svg-content\"></i> Daily Wins</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">5 Lions Megaways</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Emperor Caishen</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Release the Kraken 2</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wisdom of Athena</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Aztec Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rujak Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-populer svg-content\"></i> Hot Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Neko</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Tiger</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Treasures of Aztec</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wild Bandito</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Dreams of Macau</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rooster Rumble</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
                <div class=\"disclaimer\">
                    <div class=\"container\">
                        <div class=\"article\" id=\"post-2\">
                            <div id=\"post-34\">
                                <h1 data-amp-original-style=\"text-align: center;\" class=\"amp-wp-cdd8ca0\"><strong>Peka777 Alternatif : Situs Game Top Reward Terpercaya benefit</strong></h1>
                            </div>
                        </div>
                    </div>
                </div>","Peka777 Alternatif : Situs Game Top Reward Terpercaya benefit","","publish","closed","closed","","peka777-alternatif-situs-game-top-reward-terpercaya-benefit","","","2025-12-07 14:30:11","2025-12-07 14:30:11","","0","http://peka777.net/peka777-alternatif-situs-game-top-reward-terpercaya-benefit/","0","page","","0");
INSERT INTO `wp_posts` VALUES("6","0","2025-12-07 14:30:12","2025-12-07 14:30:12","<div class=\"main\">
                <div class=\"slide\">
                    <div class=\"row\">
                        <div class=\"main-slide col-sm-12\">
                            <amp-img alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\" width=\"1920\" height=\"613\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\"></amp-img>
                        </div>
                    </div>
                </div>
                <div class=\"menu-mobile mobile\">
                    <div class=\"container\">
                        <div class=\"row\">
                            <div class=\"col-sm-12\">
                                <div class=\"menu-login-menu-container\">
                                    <ul id=\"menu-login-menu-1\" class=\"login-mobile\">
                                        <li class=\"daftar menu-item menu-item-type-custom menu-item-object-custom menu-item-20\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/SatelitMabarr88\">Daftar</a></li>
<li class=\"login menu-item menu-item-type-custom menu-item-object-custom menu-item-21\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/Mabar88\">Login</a></li>
</ul>
                                </div>
                                <div class=\"menu-main-homepage-container\">
                                    <ul id=\"menu-main-homepage\" class=\"main-homepage\">
                                        <li id=\"menu-item-84\" class=\"menu-item menu-item-type-post_type menu-item-object-page menu-item-home current-menu-item page_item page-item-2 current_page_item menu-item-84\"><a href=\"[get_bloginfo]url[/get_bloginfo]\" aria-current=\"page\"><i class=\"svg-beranda svg-menu\"></i> Home</a></li>
                                        <li id=\"menu-item-29\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-29\"><a href=\"#\"><i class=\"svg-hot svg-menu\"></i> Hot Games</a></li>
                                        <li id=\"menu-item-30\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-30\"><a href=\"#\"><i class=\"svg-slots svg-menu\"></i> Slots</a></li>
                                        <li id=\"menu-item-31\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-31\"><a href=\"#\"><i class=\"svg-casino svg-menu\"></i> Live Casino</a></li>
                                        <li id=\"menu-item-36\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-36\"><a href=\"#\"><i class=\"svg-sport svg-menu\"></i> Sports</a></li>
                                        <li id=\"menu-item-81\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-81\"><a href=\"#\"><i class=\"svg-fishing svg-menu\"></i> Arcade</a></li>
                                        <li id=\"menu-item-82\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-82\"><a href=\"#\"><i class=\"svg-poker svg-menu\"></i> Poker</a></li>
                                        <li id=\"menu-item-83\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-83\"><a href=\"#\"><i class=\"svg-togel svg-menu\"></i> Togel Online</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class=\"bg-rounded\">
                    <div class=\"container\">
                        <div class=\"jackpot\">
                            <div class=\"row\">
                                <div class=\"col-sm-12\">
                                    <amp-anim alt=\"Jackpot Slot\" src=\"https://peka777.net/wp-content/themes/mabar88/images/tips-menang.webp\" width=\"640\" height=\"183\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                    </amp-anim>
                                </div>
                            </div>
                        </div>
                        <div class=\"games\">
                            <div class=\"title-row col-sm-12\"><i class=\"svg-gacor svg-content\"></i> Best Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Mahjong Wins 3</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Almighty Zeus Wilds™</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Twins Nexus</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Gods</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">SixSixSix</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Beam Boys</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-new svg-content\"></i> Daily Wins</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">5 Lions Megaways</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Emperor Caishen</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Release the Kraken 2</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wisdom of Athena</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Aztec Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rujak Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-populer svg-content\"></i> Hot Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Neko</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Tiger</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Treasures of Aztec</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wild Bandito</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Dreams of Macau</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rooster Rumble</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
                <div class=\"disclaimer\">
                    <div class=\"container\">
                        <div class=\"article\" id=\"post-2\">
                            <div id=\"post-26\">
                                <h1 data-amp-original-style=\"text-align: center;\" class=\"amp-wp-cdd8ca0\"><strong>Peka777 Daftar : Situs Game Top Reward Besar Terpercaya benefit</strong></h1>
                            </div>
                        </div>
                    </div>
                </div>","Peka777 Daftar : Situs Game Top Reward Besar Terpercaya benefit","","publish","closed","closed","","peka777-daftar-situs-game-top-reward-besar-terpercaya-benefit","","","2025-12-07 14:30:12","2025-12-07 14:30:12","","0","http://peka777.net/peka777-daftar-situs-game-top-reward-besar-terpercaya-benefit/","0","page","","0");
INSERT INTO `wp_posts` VALUES("7","0","2025-12-07 14:30:12","2025-12-07 14:30:12","<div class=\"main\">
                <div class=\"slide\">
                    <div class=\"row\">
                        <div class=\"main-slide col-sm-12\">
                            <amp-img alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\" width=\"1920\" height=\"613\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\"></amp-img>
                        </div>
                    </div>
                </div>
                <div class=\"menu-mobile mobile\">
                    <div class=\"container\">
                        <div class=\"row\">
                            <div class=\"col-sm-12\">
                                <div class=\"menu-login-menu-container\">
                                    <ul id=\"menu-login-menu-1\" class=\"login-mobile\">
                                        <li class=\"daftar menu-item menu-item-type-custom menu-item-object-custom menu-item-20\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/SatelitMabarr88\">Daftar</a></li>
<li class=\"login menu-item menu-item-type-custom menu-item-object-custom menu-item-21\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/Mabar88\">Login</a></li>
</ul>
                                </div>
                                <div class=\"menu-main-homepage-container\">
                                    <ul id=\"menu-main-homepage\" class=\"main-homepage\">
                                        <li id=\"menu-item-84\" class=\"menu-item menu-item-type-post_type menu-item-object-page menu-item-home current-menu-item page_item page-item-2 current_page_item menu-item-84\"><a href=\"[get_bloginfo]url[/get_bloginfo]\" aria-current=\"page\"><i class=\"svg-beranda svg-menu\"></i> Home</a></li>
                                        <li id=\"menu-item-29\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-29\"><a href=\"#\"><i class=\"svg-hot svg-menu\"></i> Hot Games</a></li>
                                        <li id=\"menu-item-30\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-30\"><a href=\"#\"><i class=\"svg-slots svg-menu\"></i> Slots</a></li>
                                        <li id=\"menu-item-31\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-31\"><a href=\"#\"><i class=\"svg-casino svg-menu\"></i> Live Casino</a></li>
                                        <li id=\"menu-item-36\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-36\"><a href=\"#\"><i class=\"svg-sport svg-menu\"></i> Sports</a></li>
                                        <li id=\"menu-item-81\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-81\"><a href=\"#\"><i class=\"svg-fishing svg-menu\"></i> Arcade</a></li>
                                        <li id=\"menu-item-82\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-82\"><a href=\"#\"><i class=\"svg-poker svg-menu\"></i> Poker</a></li>
                                        <li id=\"menu-item-83\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-83\"><a href=\"#\"><i class=\"svg-togel svg-menu\"></i> Togel Online</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class=\"bg-rounded\">
                    <div class=\"container\">
                        <div class=\"jackpot\">
                            <div class=\"row\">
                                <div class=\"col-sm-12\">
                                    <amp-anim alt=\"Jackpot Slot\" src=\"https://peka777.net/wp-content/themes/mabar88/images/tips-menang.webp\" width=\"640\" height=\"183\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                    </amp-anim>
                                </div>
                            </div>
                        </div>
                        <div class=\"games\">
                            <div class=\"title-row col-sm-12\"><i class=\"svg-gacor svg-content\"></i> Best Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Mahjong Wins 3</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Almighty Zeus Wilds™</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Twins Nexus</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Gods</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">SixSixSix</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Beam Boys</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-new svg-content\"></i> Daily Wins</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">5 Lions Megaways</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Emperor Caishen</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Release the Kraken 2</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wisdom of Athena</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Aztec Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rujak Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-populer svg-content\"></i> Hot Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Neko</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Tiger</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Treasures of Aztec</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wild Bandito</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Dreams of Macau</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rooster Rumble</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
                <div class=\"disclaimer\">
                    <div class=\"container\">
                        <div class=\"article\" id=\"post-2\">
                            <div id=\"post-95\">
                                <h1 data-amp-original-style=\"text-align: center;\" class=\"amp-wp-cdd8ca0\"><strong>Peka777 Dana : Hadiahi Diri Dengan Iphone 16, Main Gacor Hari Ini</strong></h1>
                            </div>
                        </div>
                    </div>
                </div>","Peka777 Dana : Hadiahi Diri Dengan Iphone 16, Main Gacor Hari Ini","","publish","closed","closed","","peka777-dana-hadiahi-diri-dengan-iphone-16-main-gacor-hari-ini","","","2025-12-07 14:30:12","2025-12-07 14:30:12","","0","http://peka777.net/peka777-dana-hadiahi-diri-dengan-iphone-16-main-gacor-hari-ini/","0","page","","0");
INSERT INTO `wp_posts` VALUES("8","0","2025-12-07 14:30:12","2025-12-07 14:30:12","<div class=\"main\">
                <div class=\"slide\">
                    <div class=\"row\">
                        <div class=\"main-slide col-sm-12\">
                            <amp-img alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\" width=\"1920\" height=\"613\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\"></amp-img>
                        </div>
                    </div>
                </div>
                <div class=\"menu-mobile mobile\">
                    <div class=\"container\">
                        <div class=\"row\">
                            <div class=\"col-sm-12\">
                                <div class=\"menu-login-menu-container\">
                                    <ul id=\"menu-login-menu-1\" class=\"login-mobile\">
                                        <li class=\"daftar menu-item menu-item-type-custom menu-item-object-custom menu-item-20\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/SatelitMabarr88\">Daftar</a></li>
<li class=\"login menu-item menu-item-type-custom menu-item-object-custom menu-item-21\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/Mabar88\">Login</a></li>
</ul>
                                </div>
                                <div class=\"menu-main-homepage-container\">
                                    <ul id=\"menu-main-homepage\" class=\"main-homepage\">
                                        <li id=\"menu-item-84\" class=\"menu-item menu-item-type-post_type menu-item-object-page menu-item-home current-menu-item page_item page-item-2 current_page_item menu-item-84\"><a href=\"[get_bloginfo]url[/get_bloginfo]\" aria-current=\"page\"><i class=\"svg-beranda svg-menu\"></i> Home</a></li>
                                        <li id=\"menu-item-29\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-29\"><a href=\"#\"><i class=\"svg-hot svg-menu\"></i> Hot Games</a></li>
                                        <li id=\"menu-item-30\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-30\"><a href=\"#\"><i class=\"svg-slots svg-menu\"></i> Slots</a></li>
                                        <li id=\"menu-item-31\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-31\"><a href=\"#\"><i class=\"svg-casino svg-menu\"></i> Live Casino</a></li>
                                        <li id=\"menu-item-36\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-36\"><a href=\"#\"><i class=\"svg-sport svg-menu\"></i> Sports</a></li>
                                        <li id=\"menu-item-81\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-81\"><a href=\"#\"><i class=\"svg-fishing svg-menu\"></i> Arcade</a></li>
                                        <li id=\"menu-item-82\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-82\"><a href=\"#\"><i class=\"svg-poker svg-menu\"></i> Poker</a></li>
                                        <li id=\"menu-item-83\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-83\"><a href=\"#\"><i class=\"svg-togel svg-menu\"></i> Togel Online</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class=\"bg-rounded\">
                    <div class=\"container\">
                        <div class=\"jackpot\">
                            <div class=\"row\">
                                <div class=\"col-sm-12\">
                                    <amp-anim alt=\"Jackpot Slot\" src=\"https://peka777.net/wp-content/themes/mabar88/images/tips-menang.webp\" width=\"640\" height=\"183\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                    </amp-anim>
                                </div>
                            </div>
                        </div>
                        <div class=\"games\">
                            <div class=\"title-row col-sm-12\"><i class=\"svg-gacor svg-content\"></i> Best Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Mahjong Wins 3</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Almighty Zeus Wilds™</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Twins Nexus</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Gods</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">SixSixSix</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Beam Boys</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-new svg-content\"></i> Daily Wins</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">5 Lions Megaways</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Emperor Caishen</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Release the Kraken 2</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wisdom of Athena</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Aztec Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rujak Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-populer svg-content\"></i> Hot Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Neko</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Tiger</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Treasures of Aztec</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wild Bandito</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Dreams of Macau</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rooster Rumble</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
                <div class=\"disclaimer\">
                    <div class=\"container\">
                        <div class=\"article\" id=\"post-2\">
                            <div id=\"post-98\">
                                <h1 data-amp-original-style=\"text-align: center;\" class=\"amp-wp-cdd8ca0\"><strong>Peka777 Deposit Dana : Taruhan Aman Dengan Pola Maxwin</strong></h1>
                            </div>
                        </div>
                    </div>
                </div>","Peka777 Deposit Dana : Taruhan Aman Dengan Pola Maxwin","","publish","closed","closed","","peka777-deposit-dana-taruhan-aman-dengan-pola-maxwin-3","","","2025-12-07 14:30:12","2025-12-07 14:30:12","","0","http://peka777.net/peka777-deposit-dana-taruhan-aman-dengan-pola-maxwin-3/","0","page","","0");
INSERT INTO `wp_posts` VALUES("9","0","2025-12-07 14:30:12","2025-12-07 14:30:12","<div class=\"main\">
                <div class=\"slide\">
                    <div class=\"row\">
                        <div class=\"main-slide col-sm-12\">
                            <amp-img alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\" width=\"1920\" height=\"613\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\"></amp-img>
                        </div>
                    </div>
                </div>
                <div class=\"menu-mobile mobile\">
                    <div class=\"container\">
                        <div class=\"row\">
                            <div class=\"col-sm-12\">
                                <div class=\"menu-login-menu-container\">
                                    <ul id=\"menu-login-menu-1\" class=\"login-mobile\">
                                        <li class=\"daftar menu-item menu-item-type-custom menu-item-object-custom menu-item-20\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/SatelitMabarr88\">Daftar</a></li>
<li class=\"login menu-item menu-item-type-custom menu-item-object-custom menu-item-21\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/Mabar88\">Login</a></li>
</ul>
                                </div>
                                <div class=\"menu-main-homepage-container\">
                                    <ul id=\"menu-main-homepage\" class=\"main-homepage\">
                                        <li id=\"menu-item-84\" class=\"menu-item menu-item-type-post_type menu-item-object-page menu-item-home current-menu-item page_item page-item-2 current_page_item menu-item-84\"><a href=\"[get_bloginfo]url[/get_bloginfo]\" aria-current=\"page\"><i class=\"svg-beranda svg-menu\"></i> Home</a></li>
                                        <li id=\"menu-item-29\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-29\"><a href=\"#\"><i class=\"svg-hot svg-menu\"></i> Hot Games</a></li>
                                        <li id=\"menu-item-30\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-30\"><a href=\"#\"><i class=\"svg-slots svg-menu\"></i> Slots</a></li>
                                        <li id=\"menu-item-31\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-31\"><a href=\"#\"><i class=\"svg-casino svg-menu\"></i> Live Casino</a></li>
                                        <li id=\"menu-item-36\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-36\"><a href=\"#\"><i class=\"svg-sport svg-menu\"></i> Sports</a></li>
                                        <li id=\"menu-item-81\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-81\"><a href=\"#\"><i class=\"svg-fishing svg-menu\"></i> Arcade</a></li>
                                        <li id=\"menu-item-82\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-82\"><a href=\"#\"><i class=\"svg-poker svg-menu\"></i> Poker</a></li>
                                        <li id=\"menu-item-83\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-83\"><a href=\"#\"><i class=\"svg-togel svg-menu\"></i> Togel Online</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class=\"bg-rounded\">
                    <div class=\"container\">
                        <div class=\"jackpot\">
                            <div class=\"row\">
                                <div class=\"col-sm-12\">
                                    <amp-anim alt=\"Jackpot Slot\" src=\"https://peka777.net/wp-content/themes/mabar88/images/tips-menang.webp\" width=\"640\" height=\"183\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                    </amp-anim>
                                </div>
                            </div>
                        </div>
                        <div class=\"games\">
                            <div class=\"title-row col-sm-12\"><i class=\"svg-gacor svg-content\"></i> Best Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Mahjong Wins 3</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Almighty Zeus Wilds™</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Twins Nexus</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Gods</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">SixSixSix</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Beam Boys</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-new svg-content\"></i> Daily Wins</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">5 Lions Megaways</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Emperor Caishen</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Release the Kraken 2</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wisdom of Athena</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Aztec Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rujak Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-populer svg-content\"></i> Hot Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Neko</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Tiger</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Treasures of Aztec</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wild Bandito</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Dreams of Macau</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rooster Rumble</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
                <div class=\"disclaimer\">
                    <div class=\"container\">
                        <div class=\"article\" id=\"post-2\">
                            <div id=\"post-31\">
                                <div class=\"sc-lgholE jQynwa\">
<div class=\"sc-itMJkM bJzCUQ\">
<h1 class=\"sc-Dmqmp sc-dxtBLK jzMCbW bZbZSL amp-wp-cdd8ca0\" data-amp-original-style=\"text-align: center;\"><strong><span class=\"sc-liQGml khiKJl\">Peka777 Download : Favorite Terbaik Game Cuan Online Terpopuler</span></strong></h1>
</div>
</div>
<div class=\"sc-lgholE jQynwa\"><strong><span class=\"screen-reader-text\">Pratinjau deskripsi meta:</span></strong>
<div class=\"sc-bjCGfv sc-eClPoj fxouZ kbaOxw\">
<div class=\"sc-bjCGfv fxouZ\"></div>
</div>
</div>
                            </div>
                        </div>
                    </div>
                </div>","Peka777 Download : Favorite Terbaik Game Cuan Online Terpopuler","","publish","closed","closed","","peka777-download-favorite-terbaik-game-cuan-online-terpopuler","","","2025-12-07 14:30:12","2025-12-07 14:30:12","","0","http://peka777.net/peka777-download-favorite-terbaik-game-cuan-online-terpopuler/","0","page","","0");
INSERT INTO `wp_posts` VALUES("10","0","2025-12-07 14:30:12","2025-12-07 14:30:12","<div class=\"main\">
                <div class=\"slide\">
                    <div class=\"row\">
                        <div class=\"main-slide col-sm-12\">
                            <amp-img alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\" width=\"1920\" height=\"613\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\"></amp-img>
                        </div>
                    </div>
                </div>
                <div class=\"menu-mobile mobile\">
                    <div class=\"container\">
                        <div class=\"row\">
                            <div class=\"col-sm-12\">
                                <div class=\"menu-login-menu-container\">
                                    <ul id=\"menu-login-menu-1\" class=\"login-mobile\">
                                        <li class=\"daftar menu-item menu-item-type-custom menu-item-object-custom menu-item-20\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/SatelitMabarr88\">Daftar</a></li>
<li class=\"login menu-item menu-item-type-custom menu-item-object-custom menu-item-21\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/Mabar88\">Login</a></li>
</ul>
                                </div>
                                <div class=\"menu-main-homepage-container\">
                                    <ul id=\"menu-main-homepage\" class=\"main-homepage\">
                                        <li id=\"menu-item-84\" class=\"menu-item menu-item-type-post_type menu-item-object-page menu-item-home current-menu-item page_item page-item-2 current_page_item menu-item-84\"><a href=\"[get_bloginfo]url[/get_bloginfo]\" aria-current=\"page\"><i class=\"svg-beranda svg-menu\"></i> Home</a></li>
                                        <li id=\"menu-item-29\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-29\"><a href=\"#\"><i class=\"svg-hot svg-menu\"></i> Hot Games</a></li>
                                        <li id=\"menu-item-30\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-30\"><a href=\"#\"><i class=\"svg-slots svg-menu\"></i> Slots</a></li>
                                        <li id=\"menu-item-31\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-31\"><a href=\"#\"><i class=\"svg-casino svg-menu\"></i> Live Casino</a></li>
                                        <li id=\"menu-item-36\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-36\"><a href=\"#\"><i class=\"svg-sport svg-menu\"></i> Sports</a></li>
                                        <li id=\"menu-item-81\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-81\"><a href=\"#\"><i class=\"svg-fishing svg-menu\"></i> Arcade</a></li>
                                        <li id=\"menu-item-82\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-82\"><a href=\"#\"><i class=\"svg-poker svg-menu\"></i> Poker</a></li>
                                        <li id=\"menu-item-83\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-83\"><a href=\"#\"><i class=\"svg-togel svg-menu\"></i> Togel Online</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class=\"bg-rounded\">
                    <div class=\"container\">
                        <div class=\"jackpot\">
                            <div class=\"row\">
                                <div class=\"col-sm-12\">
                                    <amp-anim alt=\"Jackpot Slot\" src=\"https://peka777.net/wp-content/themes/mabar88/images/tips-menang.webp\" width=\"640\" height=\"183\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                    </amp-anim>
                                </div>
                            </div>
                        </div>
                        <div class=\"games\">
                            <div class=\"title-row col-sm-12\"><i class=\"svg-gacor svg-content\"></i> Best Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Mahjong Wins 3</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Almighty Zeus Wilds™</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Twins Nexus</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Gods</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">SixSixSix</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Beam Boys</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-new svg-content\"></i> Daily Wins</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">5 Lions Megaways</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Emperor Caishen</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Release the Kraken 2</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wisdom of Athena</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Aztec Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rujak Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-populer svg-content\"></i> Hot Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Neko</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Tiger</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Treasures of Aztec</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wild Bandito</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Dreams of Macau</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rooster Rumble</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
                <div class=\"disclaimer\">
                    <div class=\"container\">
                        <div class=\"article\" id=\"post-2\">
                            <div id=\"post-72\">
                                <h1 data-amp-original-style=\"text-align: center;\" class=\"amp-wp-cdd8ca0\"><strong>Peka777 Hoki : Menjelajahi Dunia Olahraga Keyakinan</strong></h1>
                            </div>
                        </div>
                    </div>
                </div>","Peka777 Hoki : Menjelajahi Dunia Olahraga Keyakinan","","publish","closed","closed","","peka777-hoki-menjelajahi-dunia-olahraga-keyakinan","","","2025-12-07 14:30:12","2025-12-07 14:30:12","","0","http://peka777.net/peka777-hoki-menjelajahi-dunia-olahraga-keyakinan/","0","page","","0");
INSERT INTO `wp_posts` VALUES("11","0","2025-12-07 14:30:12","2025-12-07 14:30:12","<div class=\"main\">
                <div class=\"slide\">
                    <div class=\"row\">
                        <div class=\"main-slide col-sm-12\">
                            <amp-img alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\" width=\"1920\" height=\"613\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\"></amp-img>
                        </div>
                    </div>
                </div>
                <div class=\"menu-mobile mobile\">
                    <div class=\"container\">
                        <div class=\"row\">
                            <div class=\"col-sm-12\">
                                <div class=\"menu-login-menu-container\">
                                    <ul id=\"menu-login-menu-1\" class=\"login-mobile\">
                                        <li class=\"daftar menu-item menu-item-type-custom menu-item-object-custom menu-item-20\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/SatelitMabarr88\">Daftar</a></li>
<li class=\"login menu-item menu-item-type-custom menu-item-object-custom menu-item-21\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/Mabar88\">Login</a></li>
</ul>
                                </div>
                                <div class=\"menu-main-homepage-container\">
                                    <ul id=\"menu-main-homepage\" class=\"main-homepage\">
                                        <li id=\"menu-item-84\" class=\"menu-item menu-item-type-post_type menu-item-object-page menu-item-home current-menu-item page_item page-item-2 current_page_item menu-item-84\"><a href=\"[get_bloginfo]url[/get_bloginfo]\" aria-current=\"page\"><i class=\"svg-beranda svg-menu\"></i> Home</a></li>
                                        <li id=\"menu-item-29\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-29\"><a href=\"#\"><i class=\"svg-hot svg-menu\"></i> Hot Games</a></li>
                                        <li id=\"menu-item-30\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-30\"><a href=\"#\"><i class=\"svg-slots svg-menu\"></i> Slots</a></li>
                                        <li id=\"menu-item-31\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-31\"><a href=\"#\"><i class=\"svg-casino svg-menu\"></i> Live Casino</a></li>
                                        <li id=\"menu-item-36\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-36\"><a href=\"#\"><i class=\"svg-sport svg-menu\"></i> Sports</a></li>
                                        <li id=\"menu-item-81\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-81\"><a href=\"#\"><i class=\"svg-fishing svg-menu\"></i> Arcade</a></li>
                                        <li id=\"menu-item-82\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-82\"><a href=\"#\"><i class=\"svg-poker svg-menu\"></i> Poker</a></li>
                                        <li id=\"menu-item-83\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-83\"><a href=\"#\"><i class=\"svg-togel svg-menu\"></i> Togel Online</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class=\"bg-rounded\">
                    <div class=\"container\">
                        <div class=\"jackpot\">
                            <div class=\"row\">
                                <div class=\"col-sm-12\">
                                    <amp-anim alt=\"Jackpot Slot\" src=\"https://peka777.net/wp-content/themes/mabar88/images/tips-menang.webp\" width=\"640\" height=\"183\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                    </amp-anim>
                                </div>
                            </div>
                        </div>
                        <div class=\"games\">
                            <div class=\"title-row col-sm-12\"><i class=\"svg-gacor svg-content\"></i> Best Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Mahjong Wins 3</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Almighty Zeus Wilds™</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Twins Nexus</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Gods</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">SixSixSix</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Beam Boys</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-new svg-content\"></i> Daily Wins</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">5 Lions Megaways</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Emperor Caishen</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Release the Kraken 2</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wisdom of Athena</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Aztec Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rujak Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-populer svg-content\"></i> Hot Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Neko</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Tiger</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Treasures of Aztec</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wild Bandito</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Dreams of Macau</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rooster Rumble</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
                <div class=\"disclaimer\">
                    <div class=\"container\">
                        <div class=\"article\" id=\"post-2\">
                            <div id=\"post-35\">
                                <h1 data-amp-original-style=\"text-align: center;\" class=\"amp-wp-cdd8ca0\"><strong>Peka777 Link Alternatif : Keuntungan Besar Game Spin Online Kami</strong></h1>
                            </div>
                        </div>
                    </div>
                </div>","Peka777 Link Alternatif : Keuntungan Besar Game Spin Online Kami","","publish","closed","closed","","peka777-link-alternatif-keuntungan-besar-game-spin-online-kami","","","2025-12-07 14:30:12","2025-12-07 14:30:12","","0","http://peka777.net/peka777-link-alternatif-keuntungan-besar-game-spin-online-kami/","0","page","","0");
INSERT INTO `wp_posts` VALUES("12","0","2025-12-07 14:30:13","2025-12-07 14:30:13","<div class=\"main\">
                <div class=\"slide\">
                    <div class=\"row\">
                        <div class=\"main-slide col-sm-12\">
                            <amp-img alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\" width=\"1920\" height=\"613\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\"></amp-img>
                        </div>
                    </div>
                </div>
                <div class=\"menu-mobile mobile\">
                    <div class=\"container\">
                        <div class=\"row\">
                            <div class=\"col-sm-12\">
                                <div class=\"menu-login-menu-container\">
                                    <ul id=\"menu-login-menu-1\" class=\"login-mobile\">
                                        <li class=\"daftar menu-item menu-item-type-custom menu-item-object-custom menu-item-20\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/SatelitMabarr88\">Daftar</a></li>
<li class=\"login menu-item menu-item-type-custom menu-item-object-custom menu-item-21\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/Mabar88\">Login</a></li>
</ul>
                                </div>
                                <div class=\"menu-main-homepage-container\">
                                    <ul id=\"menu-main-homepage\" class=\"main-homepage\">
                                        <li id=\"menu-item-84\" class=\"menu-item menu-item-type-post_type menu-item-object-page menu-item-home current-menu-item page_item page-item-2 current_page_item menu-item-84\"><a href=\"[get_bloginfo]url[/get_bloginfo]\" aria-current=\"page\"><i class=\"svg-beranda svg-menu\"></i> Home</a></li>
                                        <li id=\"menu-item-29\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-29\"><a href=\"#\"><i class=\"svg-hot svg-menu\"></i> Hot Games</a></li>
                                        <li id=\"menu-item-30\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-30\"><a href=\"#\"><i class=\"svg-slots svg-menu\"></i> Slots</a></li>
                                        <li id=\"menu-item-31\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-31\"><a href=\"#\"><i class=\"svg-casino svg-menu\"></i> Live Casino</a></li>
                                        <li id=\"menu-item-36\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-36\"><a href=\"#\"><i class=\"svg-sport svg-menu\"></i> Sports</a></li>
                                        <li id=\"menu-item-81\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-81\"><a href=\"#\"><i class=\"svg-fishing svg-menu\"></i> Arcade</a></li>
                                        <li id=\"menu-item-82\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-82\"><a href=\"#\"><i class=\"svg-poker svg-menu\"></i> Poker</a></li>
                                        <li id=\"menu-item-83\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-83\"><a href=\"#\"><i class=\"svg-togel svg-menu\"></i> Togel Online</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class=\"bg-rounded\">
                    <div class=\"container\">
                        <div class=\"jackpot\">
                            <div class=\"row\">
                                <div class=\"col-sm-12\">
                                    <amp-anim alt=\"Jackpot Slot\" src=\"https://peka777.net/wp-content/themes/mabar88/images/tips-menang.webp\" width=\"640\" height=\"183\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                    </amp-anim>
                                </div>
                            </div>
                        </div>
                        <div class=\"games\">
                            <div class=\"title-row col-sm-12\"><i class=\"svg-gacor svg-content\"></i> Best Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Mahjong Wins 3</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Almighty Zeus Wilds™</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Twins Nexus</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Gods</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">SixSixSix</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Beam Boys</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-new svg-content\"></i> Daily Wins</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">5 Lions Megaways</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Emperor Caishen</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Release the Kraken 2</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wisdom of Athena</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Aztec Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rujak Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-populer svg-content\"></i> Hot Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Neko</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Tiger</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Treasures of Aztec</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wild Bandito</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Dreams of Macau</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rooster Rumble</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
                <div class=\"disclaimer\">
                    <div class=\"container\">
                        <div class=\"article\" id=\"post-2\">
                            <div id=\"post-30\">
                                <div class=\"sc-lgholE jQynwa\">
<div class=\"sc-itMJkM bJzCUQ\">
<h1 class=\"sc-Dmqmp sc-dxtBLK jzMCbW bZbZSL amp-wp-cdd8ca0\" data-amp-original-style=\"text-align: center;\"><strong><span class=\"sc-liQGml khiKJl\">Peka777 Login : Best Games Online Big Win Populer Dan Terbaik</span></strong></h1>
</div>
</div>
<h1 class=\"sc-lgholE jQynwa amp-wp-cdd8ca0\" data-amp-original-style=\"text-align: center;\"><strong><span class=\"screen-reader-text\">Pratinjau deskripsi meta:</span></strong></h1>
<div class=\"sc-bjCGfv fxouZ\">
<div class=\"sc-bjCGfv fxouZ\"></div>
</div>
                            </div>
                        </div>
                    </div>
                </div>","Peka777 Login : Best Games Online Big Win Populer Dan Terbaik","","publish","closed","closed","","peka777-login-best-games-online-big-win-populer-dan-terbaik","","","2025-12-07 14:30:13","2025-12-07 14:30:13","","0","http://peka777.net/peka777-login-best-games-online-big-win-populer-dan-terbaik/","0","page","","0");
INSERT INTO `wp_posts` VALUES("13","0","2025-12-07 14:30:13","2025-12-07 14:30:13","<div class=\"main\">
                <div class=\"slide\">
                    <div class=\"row\">
                        <div class=\"main-slide col-sm-12\">
                            <amp-img alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\" width=\"1920\" height=\"613\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\"></amp-img>
                        </div>
                    </div>
                </div>
                <div class=\"menu-mobile mobile\">
                    <div class=\"container\">
                        <div class=\"row\">
                            <div class=\"col-sm-12\">
                                <div class=\"menu-login-menu-container\">
                                    <ul id=\"menu-login-menu-1\" class=\"login-mobile\">
                                        <li class=\"daftar menu-item menu-item-type-custom menu-item-object-custom menu-item-20\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/SatelitMabarr88\">Daftar</a></li>
<li class=\"login menu-item menu-item-type-custom menu-item-object-custom menu-item-21\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/Mabar88\">Login</a></li>
</ul>
                                </div>
                                <div class=\"menu-main-homepage-container\">
                                    <ul id=\"menu-main-homepage\" class=\"main-homepage\">
                                        <li id=\"menu-item-84\" class=\"menu-item menu-item-type-post_type menu-item-object-page menu-item-home current-menu-item page_item page-item-2 current_page_item menu-item-84\"><a href=\"[get_bloginfo]url[/get_bloginfo]\" aria-current=\"page\"><i class=\"svg-beranda svg-menu\"></i> Home</a></li>
                                        <li id=\"menu-item-29\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-29\"><a href=\"#\"><i class=\"svg-hot svg-menu\"></i> Hot Games</a></li>
                                        <li id=\"menu-item-30\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-30\"><a href=\"#\"><i class=\"svg-slots svg-menu\"></i> Slots</a></li>
                                        <li id=\"menu-item-31\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-31\"><a href=\"#\"><i class=\"svg-casino svg-menu\"></i> Live Casino</a></li>
                                        <li id=\"menu-item-36\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-36\"><a href=\"#\"><i class=\"svg-sport svg-menu\"></i> Sports</a></li>
                                        <li id=\"menu-item-81\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-81\"><a href=\"#\"><i class=\"svg-fishing svg-menu\"></i> Arcade</a></li>
                                        <li id=\"menu-item-82\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-82\"><a href=\"#\"><i class=\"svg-poker svg-menu\"></i> Poker</a></li>
                                        <li id=\"menu-item-83\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-83\"><a href=\"#\"><i class=\"svg-togel svg-menu\"></i> Togel Online</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class=\"bg-rounded\">
                    <div class=\"container\">
                        <div class=\"jackpot\">
                            <div class=\"row\">
                                <div class=\"col-sm-12\">
                                    <amp-anim alt=\"Jackpot Slot\" src=\"https://peka777.net/wp-content/themes/mabar88/images/tips-menang.webp\" width=\"640\" height=\"183\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                    </amp-anim>
                                </div>
                            </div>
                        </div>
                        <div class=\"games\">
                            <div class=\"title-row col-sm-12\"><i class=\"svg-gacor svg-content\"></i> Best Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Mahjong Wins 3</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Almighty Zeus Wilds™</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Twins Nexus</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Gods</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">SixSixSix</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Beam Boys</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-new svg-content\"></i> Daily Wins</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">5 Lions Megaways</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Emperor Caishen</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Release the Kraken 2</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wisdom of Athena</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Aztec Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rujak Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-populer svg-content\"></i> Hot Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Neko</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Tiger</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Treasures of Aztec</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wild Bandito</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Dreams of Macau</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rooster Rumble</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
                <div class=\"disclaimer\">
                    <div class=\"container\">
                        <div class=\"article\" id=\"post-2\">
                            <div id=\"post-74\">
                                <h1 data-amp-original-style=\"text-align: center;\" class=\"amp-wp-cdd8ca0\"><strong>Peka777 Pulsa : Menjelajahi Dunia Olah</strong>raga Keyakinan</h1>
                            </div>
                        </div>
                    </div>
                </div>","Peka777 Pulsa : Menjelajahi Dunia Olahraga Keyakinan","","publish","closed","closed","","peka777-pulsa-menjelajahi-dunia-olahraga-keyakinan","","","2025-12-07 14:30:13","2025-12-07 14:30:13","","0","http://peka777.net/peka777-pulsa-menjelajahi-dunia-olahraga-keyakinan/","0","page","","0");
INSERT INTO `wp_posts` VALUES("14","0","2025-12-07 14:30:13","2025-12-07 14:30:13","<div class=\"main\">
                <div class=\"slide\">
                    <div class=\"row\">
                        <div class=\"main-slide col-sm-12\">
                            <amp-img alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\" width=\"1920\" height=\"613\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\"></amp-img>
                        </div>
                    </div>
                </div>
                <div class=\"menu-mobile mobile\">
                    <div class=\"container\">
                        <div class=\"row\">
                            <div class=\"col-sm-12\">
                                <div class=\"menu-login-menu-container\">
                                    <ul id=\"menu-login-menu-1\" class=\"login-mobile\">
                                        <li class=\"daftar menu-item menu-item-type-custom menu-item-object-custom menu-item-20\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/SatelitMabarr88\">Daftar</a></li>
<li class=\"login menu-item menu-item-type-custom menu-item-object-custom menu-item-21\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/Mabar88\">Login</a></li>
</ul>
                                </div>
                                <div class=\"menu-main-homepage-container\">
                                    <ul id=\"menu-main-homepage\" class=\"main-homepage\">
                                        <li id=\"menu-item-84\" class=\"menu-item menu-item-type-post_type menu-item-object-page menu-item-home current-menu-item page_item page-item-2 current_page_item menu-item-84\"><a href=\"[get_bloginfo]url[/get_bloginfo]\" aria-current=\"page\"><i class=\"svg-beranda svg-menu\"></i> Home</a></li>
                                        <li id=\"menu-item-29\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-29\"><a href=\"#\"><i class=\"svg-hot svg-menu\"></i> Hot Games</a></li>
                                        <li id=\"menu-item-30\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-30\"><a href=\"#\"><i class=\"svg-slots svg-menu\"></i> Slots</a></li>
                                        <li id=\"menu-item-31\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-31\"><a href=\"#\"><i class=\"svg-casino svg-menu\"></i> Live Casino</a></li>
                                        <li id=\"menu-item-36\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-36\"><a href=\"#\"><i class=\"svg-sport svg-menu\"></i> Sports</a></li>
                                        <li id=\"menu-item-81\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-81\"><a href=\"#\"><i class=\"svg-fishing svg-menu\"></i> Arcade</a></li>
                                        <li id=\"menu-item-82\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-82\"><a href=\"#\"><i class=\"svg-poker svg-menu\"></i> Poker</a></li>
                                        <li id=\"menu-item-83\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-83\"><a href=\"#\"><i class=\"svg-togel svg-menu\"></i> Togel Online</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class=\"bg-rounded\">
                    <div class=\"container\">
                        <div class=\"jackpot\">
                            <div class=\"row\">
                                <div class=\"col-sm-12\">
                                    <amp-anim alt=\"Jackpot Slot\" src=\"https://peka777.net/wp-content/themes/mabar88/images/tips-menang.webp\" width=\"640\" height=\"183\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                    </amp-anim>
                                </div>
                            </div>
                        </div>
                        <div class=\"games\">
                            <div class=\"title-row col-sm-12\"><i class=\"svg-gacor svg-content\"></i> Best Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Mahjong Wins 3</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Almighty Zeus Wilds™</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Twins Nexus</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Gods</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">SixSixSix</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Beam Boys</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-new svg-content\"></i> Daily Wins</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">5 Lions Megaways</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Emperor Caishen</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Release the Kraken 2</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wisdom of Athena</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Aztec Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rujak Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-populer svg-content\"></i> Hot Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Neko</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Tiger</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Treasures of Aztec</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wild Bandito</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Dreams of Macau</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rooster Rumble</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
                <div class=\"disclaimer\">
                    <div class=\"container\">
                        <div class=\"article\" id=\"post-2\">
                            <div id=\"post-29\">
                                <h1 data-amp-original-style=\"text-align: center;\" class=\"amp-wp-cdd8ca0\"><strong>Peka777 Register : Favorite Games Terbaik Game Online Terpopuler</strong></h1>
                            </div>
                        </div>
                    </div>
                </div>","Peka777 Register : Favorite Games Terbaik Game Online Terpopuler","","publish","closed","closed","","peka777-register-favorite-games-terbaik-game-online-terpopuler","","","2025-12-07 14:30:13","2025-12-07 14:30:13","","0","http://peka777.net/peka777-register-favorite-games-terbaik-game-online-terpopuler/","0","page","","0");
INSERT INTO `wp_posts` VALUES("15","0","2025-12-07 14:30:13","2025-12-07 14:30:13","<div class=\"main\">
                <div class=\"slide\">
                    <div class=\"row\">
                        <div class=\"main-slide col-sm-12\">
                            <amp-img alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\" width=\"1920\" height=\"613\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"slider\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/slider/slider.webp\"></amp-img>
                        </div>
                    </div>
                </div>
                <div class=\"menu-mobile mobile\">
                    <div class=\"container\">
                        <div class=\"row\">
                            <div class=\"col-sm-12\">
                                <div class=\"menu-login-menu-container\">
                                    <ul id=\"menu-login-menu-1\" class=\"login-mobile\">
                                        <li class=\"daftar menu-item menu-item-type-custom menu-item-object-custom menu-item-20\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/SatelitMabarr88\">Daftar</a></li>
<li class=\"login menu-item menu-item-type-custom menu-item-object-custom menu-item-21\"><a target=\"_blank\" rel=\"nofollow\" href=\"https://bit.ly/Mabar88\">Login</a></li>
</ul>
                                </div>
                                <div class=\"menu-main-homepage-container\">
                                    <ul id=\"menu-main-homepage\" class=\"main-homepage\">
                                        <li id=\"menu-item-84\" class=\"menu-item menu-item-type-post_type menu-item-object-page menu-item-home current-menu-item page_item page-item-2 current_page_item menu-item-84\"><a href=\"[get_bloginfo]url[/get_bloginfo]\" aria-current=\"page\"><i class=\"svg-beranda svg-menu\"></i> Home</a></li>
                                        <li id=\"menu-item-29\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-29\"><a href=\"#\"><i class=\"svg-hot svg-menu\"></i> Hot Games</a></li>
                                        <li id=\"menu-item-30\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-30\"><a href=\"#\"><i class=\"svg-slots svg-menu\"></i> Slots</a></li>
                                        <li id=\"menu-item-31\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-31\"><a href=\"#\"><i class=\"svg-casino svg-menu\"></i> Live Casino</a></li>
                                        <li id=\"menu-item-36\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-36\"><a href=\"#\"><i class=\"svg-sport svg-menu\"></i> Sports</a></li>
                                        <li id=\"menu-item-81\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-81\"><a href=\"#\"><i class=\"svg-fishing svg-menu\"></i> Arcade</a></li>
                                        <li id=\"menu-item-82\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-82\"><a href=\"#\"><i class=\"svg-poker svg-menu\"></i> Poker</a></li>
                                        <li id=\"menu-item-83\" class=\"menu-item menu-item-type-custom menu-item-object-custom menu-item-83\"><a href=\"#\"><i class=\"svg-togel svg-menu\"></i> Togel Online</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class=\"bg-rounded\">
                    <div class=\"container\">
                        <div class=\"jackpot\">
                            <div class=\"row\">
                                <div class=\"col-sm-12\">
                                    <amp-anim alt=\"Jackpot Slot\" src=\"https://peka777.net/wp-content/themes/mabar88/images/tips-menang.webp\" width=\"640\" height=\"183\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                    </amp-anim>
                                </div>
                            </div>
                        </div>
                        <div class=\"games\">
                            <div class=\"title-row col-sm-12\"><i class=\"svg-gacor svg-content\"></i> Best Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Mahjong Wins 3</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Almighty Zeus Wilds™<\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds™.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Almighty Zeus Wilds™</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Mahjong Wins 3\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Twins Nexus</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer>
                                                        <img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Gods\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Gods</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasure Wild\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">SixSixSix</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Aztec Bonanza\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Beam Boys</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-new svg-content\"></i> Daily Wins</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"treasure bowl\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">5 Lions Megaways</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Break Away Lucky Wilds\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Emperor Caishen</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"1000 Wishes\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Release the Kraken 2</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Chronicles of Olympus X Up\" src=\"[get_bloginfo]url[/get_bloginfo]/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wisdom of Athena</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Elven Gold\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Aztec Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Silverback Multiplier Mountain\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rujak Bonanza</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=\"title-row col-sm-12\"><i class=\"svg-populer svg-content\"></i> Hot Games</div>
                            <div class=\"ct-rounded\">
                                <div class=\"row\">
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Phoenix Rises\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Lucky Neko</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Fortune Tiger\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Fortune Tiger</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"garuda gems\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Treasures of Aztec</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Wild Bandito\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Wild Bandito</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"wild fireworks\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Dreams of Macau</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=\"col-sm-2\">
                                        <div class=\"game-wrapper\">
                                            <div class=\"game-img\">
                                                <div class=\"image-wrapper\">
                                                    <amp-img alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\" width=\"200\" height=\"200\" class=\"amp-wp-enforced-sizes i-amphtml-layout-intrinsic i-amphtml-layout-size-defined\" layout=\"intrinsic\" data-hero-candidate=\"\" data-hero i-amphtml-ssr i-amphtml-layout=\"intrinsic\"><i-amphtml-sizer slot=\"i-amphtml-svc\" class=\"i-amphtml-sizer\"><img alt=\"\" aria-hidden=\"true\" class=\"i-amphtml-intrinsic-sizer\" role=\"presentation\" src=\"data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=\"></i-amphtml-sizer><img class=\"i-amphtml-fill-content i-amphtml-replaced-content\" decoding=\"async\" alt=\"Treasures Aztec\" src=\"https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp\"></amp-img>
                                                </div>
                                                <div class=\"games-wrapper\"></div>
                                                <div class=\"title-games\">Rooster Rumble</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
                <div class=\"disclaimer\">
                    <div class=\"container\">
                        <div class=\"article\" id=\"post-2\">
                            <div id=\"post-71\">
                                <h1 data-amp-original-style=\"text-align: center;\" class=\"amp-wp-cdd8ca0\"><strong>Peka777 Slot Login : Keuntungan Pemain Sangat Untung</strong></h1>
                            </div>
                        </div>
                    </div>
                </div>","Peka777 Slot Login : Keuntungan Pemain Sangat Untung","","publish","closed","closed","","peka777-slot-login-keuntungan-pemain-sangat-untung","","","2025-12-07 14:30:13","2025-12-07 14:30:13","","0","http://peka777.net/peka777-slot-login-keuntungan-pemain-sangat-untung/","0","page","","0");



DROP TABLE IF EXISTS `wp_term_relationships`;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `wp_term_relationships` VALUES("1","1","0");



DROP TABLE IF EXISTS `wp_term_taxonomy`;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `wp_term_taxonomy` VALUES("1","1","category","","0","1");



DROP TABLE IF EXISTS `wp_termmeta`;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;




DROP TABLE IF EXISTS `wp_terms`;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `wp_terms` VALUES("1","Uncategorized","uncategorized","0");



DROP TABLE IF EXISTS `wp_usermeta`;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `wp_usermeta` VALUES("1","1","nickname","admin3");
INSERT INTO `wp_usermeta` VALUES("2","1","first_name","");
INSERT INTO `wp_usermeta` VALUES("3","1","last_name","");
INSERT INTO `wp_usermeta` VALUES("4","1","description","");
INSERT INTO `wp_usermeta` VALUES("5","1","rich_editing","true");
INSERT INTO `wp_usermeta` VALUES("6","1","syntax_highlighting","true");
INSERT INTO `wp_usermeta` VALUES("7","1","comment_shortcuts","false");
INSERT INTO `wp_usermeta` VALUES("8","1","admin_color","fresh");
INSERT INTO `wp_usermeta` VALUES("9","1","use_ssl","0");
INSERT INTO `wp_usermeta` VALUES("10","1","show_admin_bar_front","true");
INSERT INTO `wp_usermeta` VALUES("11","1","locale","");
INSERT INTO `wp_usermeta` VALUES("12","1","wp_capabilities","a:1:{s:13:\"administrator\";b:1;}");
INSERT INTO `wp_usermeta` VALUES("13","1","wp_user_level","10");
INSERT INTO `wp_usermeta` VALUES("14","1","dismissed_wp_pointers","");
INSERT INTO `wp_usermeta` VALUES("15","1","show_welcome_panel","1");



DROP TABLE IF EXISTS `wp_users`;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `wp_users` VALUES("1","admin3","$P$BUTKr2RKBTrEoW0mJ84cZanisjO9/h1","admin3","adikurnawan@ymail.com","http://peka777.net","2025-12-07 14:26:27","","0","admin3");



DROP TABLE IF EXISTS `wp_yoast_indexable`;

CREATE TABLE `wp_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext DEFAULT NULL,
  `permalink_hash` varchar(40) DEFAULT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `object_type` varchar(32) NOT NULL,
  `object_sub_type` varchar(32) DEFAULT NULL,
  `author_id` bigint(20) DEFAULT NULL,
  `post_parent` bigint(20) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `breadcrumb_title` text DEFAULT NULL,
  `post_status` varchar(20) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT 0,
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` longtext DEFAULT NULL,
  `primary_focus_keyword` varchar(191) DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT 0,
  `is_robots_noindex` tinyint(1) DEFAULT 0,
  `is_robots_nofollow` tinyint(1) DEFAULT 0,
  `is_robots_noarchive` tinyint(1) DEFAULT 0,
  `is_robots_noimageindex` tinyint(1) DEFAULT 0,
  `is_robots_nosnippet` tinyint(1) DEFAULT 0,
  `twitter_title` text DEFAULT NULL,
  `twitter_image` longtext DEFAULT NULL,
  `twitter_description` longtext DEFAULT NULL,
  `twitter_image_id` varchar(191) DEFAULT NULL,
  `twitter_image_source` text DEFAULT NULL,
  `open_graph_title` text DEFAULT NULL,
  `open_graph_description` longtext DEFAULT NULL,
  `open_graph_image` longtext DEFAULT NULL,
  `open_graph_image_id` varchar(191) DEFAULT NULL,
  `open_graph_image_source` text DEFAULT NULL,
  `open_graph_image_meta` mediumtext DEFAULT NULL,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  `schema_page_type` varchar(64) DEFAULT NULL,
  `schema_article_type` varchar(64) DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT 0,
  `estimated_reading_time_minutes` int(11) DEFAULT NULL,
  `version` int(11) DEFAULT 1,
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `wp_yoast_indexable` VALUES("1","http://peka777.net/","42:a985abe054d3c32c4511360aa85515fe","1","post","page","0","0","Peka777 : Daftar 1 ID Game Anda Bisa Menikmati Fitur Selamanya","Peka777 Dengan semua game mobile favorit dalam satu ID, tidak hanya memperluas pengalaman, tetapi menikmati fitur ekslusif Peka 777.","Home","publish",NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","0",NULL,"0",NULL,NULL,NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,NULL,"first-content-image",NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,"first-content-image",NULL,"1","14",NULL,"2025-12-07 14:27:24","2025-12-07 14:30:13","1",NULL,NULL,NULL,NULL,"0",NULL,"2","2025-12-07 14:30:10","2025-12-07 14:30:10","0");
INSERT INTO `wp_yoast_indexable` VALUES("2","http://peka777.net/author/admin.html","59:5de938ce7b07d2c272ea6f357c55b817","2","post","page","0","0","Admin, Pengarang di Peka777",NULL,"Peka777 Deposit Dana : Taruhan Aman Dengan Pola Maxwin","publish",NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","0",NULL,"0",NULL,NULL,NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,NULL,"first-content-image",NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,"first-content-image",NULL,"1",NULL,NULL,"2025-12-07 14:27:24","2025-12-07 14:30:13","1",NULL,NULL,NULL,NULL,"0",NULL,"2","2025-12-07 14:30:11","2025-12-07 14:30:11","0");
INSERT INTO `wp_yoast_indexable` VALUES("3","http://peka777.net/category/uncategorized.html","69:c75962b165f4b7edbd1856ee5eebf0a1","3","post","page","0","0","Peka777 Arsip : Peka777",NULL,"Peka777 Deposit Dana : Taruhan Aman Dengan Pola Maxwin","publish",NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","0",NULL,"0",NULL,NULL,NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,NULL,"first-content-image",NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,"first-content-image",NULL,"1",NULL,NULL,"2025-12-07 14:27:24","2025-12-07 14:30:13","1",NULL,NULL,NULL,NULL,"0",NULL,"2","2025-12-07 14:30:11","2025-12-07 14:30:11","0");
INSERT INTO `wp_yoast_indexable` VALUES("4","http://peka777.net/link-alternatif-peka777.html","70:42c288b0e276e5d028332529d4fecebd","4","post","page","0","0","Link Alternatif Peka777 : Keuntungan Besar Game Spin Online Kami","Link Alternatif Peka777 merupakan prize pool agen game terbaik dengan sensasi kemenangan dan nikmati peluang besar meraih hadiah spektakuler.","Link Alternatif Peka777 : Keuntungan Besar Game Spin Online Kami","publish",NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","0",NULL,"0",NULL,NULL,NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,NULL,"first-content-image",NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,"first-content-image",NULL,"1",NULL,NULL,"2025-12-07 14:27:24","2025-12-07 14:30:13","1",NULL,NULL,NULL,NULL,"0",NULL,"2","2025-12-07 14:30:11","2025-12-07 14:30:11","0");
INSERT INTO `wp_yoast_indexable` VALUES("5","http://peka777.net/peka777-alternatif.html","65:88f97b6124bbb101636a35b6c2d16df4","5","post","page","0","0","Peka777 Alternatif : Situs Game Top Reward Terpercaya benefit","Peka777 Alternatif merupakan situs game online dengan reward besar yang terpercaya, memberikan berbagai benefit tinggi setiap harinya.","Peka777 Alternatif : Situs Game Top Reward Terpercaya benefit","publish",NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","0",NULL,"0",NULL,NULL,NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,NULL,"first-content-image",NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,"first-content-image",NULL,"1",NULL,NULL,"2025-12-07 14:27:24","2025-12-07 14:30:13","1",NULL,NULL,NULL,NULL,"0",NULL,"2","2025-12-07 14:30:11","2025-12-07 14:30:11","0");
INSERT INTO `wp_yoast_indexable` VALUES("6","http://peka777.net/peka777-daftar.html","61:95cec796082d5a5d5860bbe09e8c8924","6","post","page","0","0","Peka777 Daftar : Situs Game Top Reward Besar Terpercaya benefit","Peka777 Daftar merupakan situs game online populer dengan reward besar yang terpercaya, memberikan berbagai benefit tinggi setiap harinya.","Peka777 Daftar : Situs Game Top Reward Besar Terpercaya benefit","publish",NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","0",NULL,"0",NULL,NULL,NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,NULL,"first-content-image",NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,"first-content-image",NULL,"1",NULL,NULL,"2025-12-07 14:27:24","2025-12-07 14:30:13","1",NULL,NULL,NULL,NULL,"0",NULL,"2","2025-12-07 14:30:12","2025-12-07 14:30:12","0");
INSERT INTO `wp_yoast_indexable` VALUES("7","http://peka777.net/peka777-dana.html","59:99c786d2429839729a4b26ce702171f7","7","post","page","0","0","Peka777 Dana : Hadiahi Diri Dengan Iphone 16, Main Gacor Hari Ini","Peka777 Dana Main gacor dan menangkan hadiah mewah seperti iPhone 16 dan hadiah menarik lainnya. Peluang kemenangan yang lebih besar.","Peka777 Dana : Hadiahi Diri Dengan Iphone 16, Main Gacor Hari Ini","publish",NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","0",NULL,"0",NULL,NULL,NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,NULL,"first-content-image",NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,"first-content-image",NULL,"1",NULL,NULL,"2025-12-07 14:27:25","2025-12-07 14:30:13","1",NULL,NULL,NULL,NULL,"0",NULL,"2","2025-12-07 14:30:12","2025-12-07 14:30:12","0");
INSERT INTO `wp_yoast_indexable` VALUES("8","http://peka777.net/peka777-deposit-dana.html","67:4ec5d3ca35d1427e3f8433b6b5791f97","8","post","page","0","0","Peka777 Deposit Dana : Taruhan Aman Dengan Pola Maxwin","Peka777 Deposit Dana Menang maksimal dengan taruhan aman dan pola maxwin. Raih jackpot besar dengan percaya diri dapatkan bonus besarnya.","Peka777 Deposit Dana : Taruhan Aman Dengan Pola Maxwin","publish",NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","0",NULL,"0",NULL,NULL,NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,NULL,"first-content-image",NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,"first-content-image",NULL,"1",NULL,NULL,"2025-12-07 14:27:25","2025-12-07 14:30:13","1",NULL,NULL,NULL,NULL,"0",NULL,"2","2025-12-07 14:30:12","2025-12-07 14:30:12","0");
INSERT INTO `wp_yoast_indexable` VALUES("9","http://peka777.net/peka777-download.html","63:d4be0ea843374cfd16d2b5008437d24c","9","post","page","0","0","Peka777 Download : Favorite Terbaik Game Cuan Online Terpopuler","Peka777 Download adalah favorite games terbaik dalam game online yang terpopuler dalam kenyamanan bermain dan nikmati pengalaman tiap hari.","Peka777 Download : Favorite Terbaik Game Cuan Online Terpopuler","publish",NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","0",NULL,"0",NULL,NULL,NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,NULL,"first-content-image",NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,"first-content-image",NULL,"1",NULL,NULL,"2025-12-07 14:27:25","2025-12-07 14:30:13","1",NULL,NULL,NULL,NULL,"0",NULL,"2","2025-12-07 14:30:12","2025-12-07 14:30:12","0");
INSERT INTO `wp_yoast_indexable` VALUES("10","http://peka777.net/peka777-hoki.html","59:41a2bff2cd67c5ff921f2d5034e166bf","10","post","page","0","0","Peka777 Hoki : Menjelajahi Dunia Olahraga Keyakinan","Peka777 Hoki ikuti turnamen dan kompetisi situs-situs game terbaik yang menjanjikan hadiah besar dan ketenaran bagi pemenangnya.","Peka777 Hoki : Menjelajahi Dunia Olahraga Keyakinan","publish",NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","0",NULL,"0",NULL,NULL,NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,NULL,"first-content-image",NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,"first-content-image",NULL,"1",NULL,NULL,"2025-12-07 14:27:25","2025-12-07 14:30:13","1",NULL,NULL,NULL,NULL,"0",NULL,"2","2025-12-07 14:30:12","2025-12-07 14:30:12","0");
INSERT INTO `wp_yoast_indexable` VALUES("11","http://peka777.net/peka777-link-alternatif.html","70:4f9822ab54adc8a1253ecf27750c2c7d","11","post","page","0","0","Peka777 Link Alternatif : Keuntungan Besar Game Spin Online Kami","Peka777 Link Alternatif merupakan keuntungan besar setiap hari dalam game online kami dalam tinggi dan raih hadiah-hadiah menarik sekali.","Peka777 Link Alternatif : Keuntungan Besar Game Spin Online Kami","publish",NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","0",NULL,"0",NULL,NULL,NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,NULL,"first-content-image",NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,"first-content-image",NULL,"1",NULL,NULL,"2025-12-07 14:27:25","2025-12-07 14:30:13","1",NULL,NULL,NULL,NULL,"0",NULL,"2","2025-12-07 14:30:12","2025-12-07 14:30:12","0");
INSERT INTO `wp_yoast_indexable` VALUES("12","http://peka777.net/peka777-login.html","60:608640088fe7de5145b4d29c43aa8d0f","12","post","page","0","0","Peka777 Login : Best Games Online Big Win Populer Dan Terbaik","Peka777 Login merupakan best games online dengan Reward yang populer dan terbaik dalam pengalaman dan raih peluang besar meraih kemenangan.","Peka777 Login : Best Games Online Big Win Populer Dan Terbaik","publish",NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","0",NULL,"0",NULL,NULL,NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,NULL,"first-content-image",NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,"first-content-image",NULL,"1",NULL,NULL,"2025-12-07 14:27:25","2025-12-07 14:30:13","1",NULL,NULL,NULL,NULL,"0",NULL,"2","2025-12-07 14:30:13","2025-12-07 14:30:13","0");
INSERT INTO `wp_yoast_indexable` VALUES("13","http://peka777.net/peka777-pulsa.html","60:34f9f5ef2b2c6517409c715499141c03","13","post","page","0","0","Peka777 Pulsa : Menjelajahi Dunia Olahraga Keyakinan","Peka777 Pulsa ikuti turnamen dan kompetisi situs-situs game terbaik yang menjanjikan hadiah besar dan ketenaran bagi pemenangnya.","Peka777 Pulsa : Menjelajahi Dunia Olahraga Keyakinan","publish",NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","0",NULL,"0",NULL,NULL,NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,NULL,"first-content-image",NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,"first-content-image",NULL,"1",NULL,NULL,"2025-12-07 14:27:25","2025-12-07 14:30:13","1",NULL,NULL,NULL,NULL,"0",NULL,"2","2025-12-07 14:30:13","2025-12-07 14:30:13","0");
INSERT INTO `wp_yoast_indexable` VALUES("14","http://peka777.net/peka777-register.html","63:7950445cde8304a24c6634e670b81f81","14","post","page","0","0","Peka777 Register : Favorite Games Terbaik Game Online Terpopuler","Peka777 Register adalah favorite games terbaik dalam game online yang terpopuler dalam kenyamanan bermain dan nikmati pengalaman tiap hari.","Peka777 Register : Favorite Games Terbaik Game Online Terpopuler","publish",NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","0",NULL,"0",NULL,NULL,NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,NULL,"first-content-image",NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,"first-content-image",NULL,"1",NULL,NULL,"2025-12-07 14:27:26","2025-12-07 14:30:13","1",NULL,NULL,NULL,NULL,"0",NULL,"2","2025-12-07 14:30:13","2025-12-07 14:30:13","0");
INSERT INTO `wp_yoast_indexable` VALUES("15","http://peka777.net/peka777-slot-login.html","65:21dc39a66d31f06c0b958b0d2fe460c7","15","post","page","0","0","Peka777 Slot Login : Keuntungan Pemain Sangat Untung","Peka777 Slot Login temukan situs-situs terbaik yang pasar Asia dengan grafis yang memukau dan peluang penghasilan melimpah.","Peka777 Slot Login : Keuntungan Pemain Sangat Untung","publish",NULL,"0",NULL,NULL,NULL,NULL,NULL,"0","0",NULL,"0",NULL,NULL,NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,NULL,"first-content-image",NULL,NULL,"https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp",NULL,"first-content-image",NULL,"1",NULL,NULL,"2025-12-07 14:27:26","2025-12-07 14:30:13","1",NULL,NULL,NULL,NULL,"0",NULL,"2","2025-12-07 14:30:13","2025-12-07 14:30:13","0");
INSERT INTO `wp_yoast_indexable` VALUES("16",NULL,NULL,NULL,"system-page","404",NULL,NULL,"Page not found %%sep%% %%sitename%%",NULL,"Error 404: Page not found",NULL,NULL,"0",NULL,NULL,NULL,NULL,NULL,NULL,"0","1","0","0","0","0",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"2025-12-07 14:28:02","2025-12-07 14:28:02","1",NULL,NULL,NULL,NULL,"0",NULL,"1",NULL,NULL,NULL);



DROP TABLE IF EXISTS `wp_yoast_indexable_hierarchy`;

CREATE TABLE `wp_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `wp_yoast_indexable_hierarchy` VALUES("1","0","0","1");
INSERT INTO `wp_yoast_indexable_hierarchy` VALUES("2","0","0","1");
INSERT INTO `wp_yoast_indexable_hierarchy` VALUES("3","0","0","1");
INSERT INTO `wp_yoast_indexable_hierarchy` VALUES("4","0","0","1");
INSERT INTO `wp_yoast_indexable_hierarchy` VALUES("5","0","0","1");
INSERT INTO `wp_yoast_indexable_hierarchy` VALUES("6","0","0","1");
INSERT INTO `wp_yoast_indexable_hierarchy` VALUES("7","0","0","1");
INSERT INTO `wp_yoast_indexable_hierarchy` VALUES("8","0","0","1");
INSERT INTO `wp_yoast_indexable_hierarchy` VALUES("9","0","0","1");
INSERT INTO `wp_yoast_indexable_hierarchy` VALUES("10","0","0","1");
INSERT INTO `wp_yoast_indexable_hierarchy` VALUES("11","0","0","1");
INSERT INTO `wp_yoast_indexable_hierarchy` VALUES("12","0","0","1");
INSERT INTO `wp_yoast_indexable_hierarchy` VALUES("13","0","0","1");
INSERT INTO `wp_yoast_indexable_hierarchy` VALUES("14","0","0","1");
INSERT INTO `wp_yoast_indexable_hierarchy` VALUES("15","0","0","1");



DROP TABLE IF EXISTS `wp_yoast_migrations`;

CREATE TABLE `wp_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wp_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `wp_yoast_migrations` VALUES("1","20171228151840");
INSERT INTO `wp_yoast_migrations` VALUES("2","20171228151841");
INSERT INTO `wp_yoast_migrations` VALUES("3","20190529075038");
INSERT INTO `wp_yoast_migrations` VALUES("4","20191011111109");
INSERT INTO `wp_yoast_migrations` VALUES("5","20200408101900");
INSERT INTO `wp_yoast_migrations` VALUES("6","20200420073606");
INSERT INTO `wp_yoast_migrations` VALUES("7","20200428123747");
INSERT INTO `wp_yoast_migrations` VALUES("8","20200428194858");
INSERT INTO `wp_yoast_migrations` VALUES("9","20200429105310");
INSERT INTO `wp_yoast_migrations` VALUES("10","20200430075614");
INSERT INTO `wp_yoast_migrations` VALUES("11","20200430150130");
INSERT INTO `wp_yoast_migrations` VALUES("12","20200507054848");
INSERT INTO `wp_yoast_migrations` VALUES("13","20200513133401");
INSERT INTO `wp_yoast_migrations` VALUES("14","20200609154515");
INSERT INTO `wp_yoast_migrations` VALUES("15","20200616130143");
INSERT INTO `wp_yoast_migrations` VALUES("16","20200617122511");
INSERT INTO `wp_yoast_migrations` VALUES("17","20200702141921");
INSERT INTO `wp_yoast_migrations` VALUES("18","20200728095334");
INSERT INTO `wp_yoast_migrations` VALUES("19","20201202144329");
INSERT INTO `wp_yoast_migrations` VALUES("20","20201216124002");
INSERT INTO `wp_yoast_migrations` VALUES("21","20201216141134");
INSERT INTO `wp_yoast_migrations` VALUES("22","20210817092415");
INSERT INTO `wp_yoast_migrations` VALUES("23","20211020091404");
INSERT INTO `wp_yoast_migrations` VALUES("24","20230417083836");



DROP TABLE IF EXISTS `wp_yoast_primary_term`;

CREATE TABLE `wp_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `term_id` bigint(20) DEFAULT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;




DROP TABLE IF EXISTS `wp_yoast_seo_links`;

CREATE TABLE `wp_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `target_post_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=376 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `wp_yoast_seo_links` VALUES("1","https://bit.ly/SatelitMabarr88","1",NULL,"external","1",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("2","https://bit.ly/Mabar88","1",NULL,"external","1",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("3","http://peka777.net","1",NULL,"internal","1",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("4","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+","1",NULL,"image-ex","1",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("5","http://peka777.net/files/wp-content/themes/mabar88/images/slider/slider.webp","1",NULL,"image-in","1",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("6","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","1",NULL,"image-ex","1",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("7","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","1",NULL,"image-ex","1",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("8","http://peka777.net/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds&trade;.webp","1",NULL,"image-in","1",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("9","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp","1",NULL,"image-in","1",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("10","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp","1",NULL,"image-in","1",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("11","https://bit.ly/SatelitMabarr88","2",NULL,"external","2",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("12","https://bit.ly/Mabar88","2",NULL,"external","2",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("13","http://peka777.net","2","1","internal","2","1",NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("14","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+","2",NULL,"image-ex","2",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("15","http://peka777.net/files/wp-content/themes/mabar88/images/slider/slider.webp","2",NULL,"image-in","2",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("16","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","2",NULL,"image-ex","2",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("17","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","2",NULL,"image-ex","2",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("18","http://peka777.net/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds&trade;.webp","2",NULL,"image-in","2",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("19","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp","2",NULL,"image-in","2",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("20","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp","2",NULL,"image-in","2",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("21","https://bit.ly/SatelitMabarr88","3",NULL,"external","3",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("22","https://bit.ly/Mabar88","3",NULL,"external","3",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("23","http://peka777.net","3","1","internal","3","1",NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("24","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+","3",NULL,"image-ex","3",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("25","http://peka777.net/files/wp-content/themes/mabar88/images/slider/slider.webp","3",NULL,"image-in","3",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("26","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","3",NULL,"image-ex","3",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("27","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","3",NULL,"image-ex","3",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("28","http://peka777.net/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds&trade;.webp","3",NULL,"image-in","3",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("29","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp","3",NULL,"image-in","3",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("30","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp","3",NULL,"image-in","3",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("31","https://bit.ly/SatelitMabarr88","4",NULL,"external","4",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("32","https://bit.ly/Mabar88","4",NULL,"external","4",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("33","http://peka777.net","4","1","internal","4","1",NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("34","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+","4",NULL,"image-ex","4",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("35","http://peka777.net/files/wp-content/themes/mabar88/images/slider/slider.webp","4",NULL,"image-in","4",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("36","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","4",NULL,"image-ex","4",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("37","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","4",NULL,"image-ex","4",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("38","http://peka777.net/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds&trade;.webp","4",NULL,"image-in","4",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("39","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp","4",NULL,"image-in","4",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("40","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp","4",NULL,"image-in","4",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("41","https://bit.ly/SatelitMabarr88","5",NULL,"external","5",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("42","https://bit.ly/Mabar88","5",NULL,"external","5",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("43","http://peka777.net","5","1","internal","5","1",NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("44","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+","5",NULL,"image-ex","5",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("45","http://peka777.net/files/wp-content/themes/mabar88/images/slider/slider.webp","5",NULL,"image-in","5",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("46","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","5",NULL,"image-ex","5",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("47","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","5",NULL,"image-ex","5",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("48","http://peka777.net/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds&trade;.webp","5",NULL,"image-in","5",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("49","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp","5",NULL,"image-in","5",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("50","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp","5",NULL,"image-in","5",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("51","https://bit.ly/SatelitMabarr88","6",NULL,"external","6",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("52","https://bit.ly/Mabar88","6",NULL,"external","6",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("53","http://peka777.net","6","1","internal","6","1",NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("54","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+","6",NULL,"image-ex","6",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("55","http://peka777.net/files/wp-content/themes/mabar88/images/slider/slider.webp","6",NULL,"image-in","6",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("56","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","6",NULL,"image-ex","6",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("57","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","6",NULL,"image-ex","6",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("58","http://peka777.net/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds&trade;.webp","6",NULL,"image-in","6",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("59","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp","6",NULL,"image-in","6",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("60","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp","6",NULL,"image-in","6",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("61","https://bit.ly/SatelitMabarr88","7",NULL,"external","7",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("62","https://bit.ly/Mabar88","7",NULL,"external","7",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("63","http://peka777.net","7","1","internal","7","1",NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("64","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+","7",NULL,"image-ex","7",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("65","http://peka777.net/files/wp-content/themes/mabar88/images/slider/slider.webp","7",NULL,"image-in","7",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("66","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","7",NULL,"image-ex","7",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("67","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","7",NULL,"image-ex","7",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("68","http://peka777.net/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds&trade;.webp","7",NULL,"image-in","7",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("69","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp","7",NULL,"image-in","7",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("70","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp","7",NULL,"image-in","7",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("71","https://bit.ly/SatelitMabarr88","8",NULL,"external","8",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("72","https://bit.ly/Mabar88","8",NULL,"external","8",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("73","http://peka777.net","8","1","internal","8","1",NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("74","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+","8",NULL,"image-ex","8",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("75","http://peka777.net/files/wp-content/themes/mabar88/images/slider/slider.webp","8",NULL,"image-in","8",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("76","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","8",NULL,"image-ex","8",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("77","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","8",NULL,"image-ex","8",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("78","http://peka777.net/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds&trade;.webp","8",NULL,"image-in","8",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("79","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp","8",NULL,"image-in","8",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("80","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp","8",NULL,"image-in","8",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("81","https://bit.ly/SatelitMabarr88","9",NULL,"external","9",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("82","https://bit.ly/Mabar88","9",NULL,"external","9",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("83","http://peka777.net","9","1","internal","9","1",NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("84","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+","9",NULL,"image-ex","9",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("85","http://peka777.net/files/wp-content/themes/mabar88/images/slider/slider.webp","9",NULL,"image-in","9",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("86","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","9",NULL,"image-ex","9",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("87","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","9",NULL,"image-ex","9",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("88","http://peka777.net/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds&trade;.webp","9",NULL,"image-in","9",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("89","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp","9",NULL,"image-in","9",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("90","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp","9",NULL,"image-in","9",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("91","https://bit.ly/SatelitMabarr88","10",NULL,"external","10",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("92","https://bit.ly/Mabar88","10",NULL,"external","10",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("93","http://peka777.net","10","1","internal","10","1",NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("94","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+","10",NULL,"image-ex","10",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("95","http://peka777.net/files/wp-content/themes/mabar88/images/slider/slider.webp","10",NULL,"image-in","10",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("96","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","10",NULL,"image-ex","10",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("97","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","10",NULL,"image-ex","10",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("98","http://peka777.net/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds&trade;.webp","10",NULL,"image-in","10",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("99","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp","10",NULL,"image-in","10",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("100","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp","10",NULL,"image-in","10",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("101","https://bit.ly/SatelitMabarr88","11",NULL,"external","11",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("102","https://bit.ly/Mabar88","11",NULL,"external","11",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("103","http://peka777.net","11","1","internal","11","1",NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("104","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+","11",NULL,"image-ex","11",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("105","http://peka777.net/files/wp-content/themes/mabar88/images/slider/slider.webp","11",NULL,"image-in","11",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("106","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","11",NULL,"image-ex","11",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("107","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","11",NULL,"image-ex","11",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("108","http://peka777.net/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds&trade;.webp","11",NULL,"image-in","11",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("109","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp","11",NULL,"image-in","11",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("110","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp","11",NULL,"image-in","11",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("111","https://bit.ly/SatelitMabarr88","12",NULL,"external","12",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("112","https://bit.ly/Mabar88","12",NULL,"external","12",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("113","http://peka777.net","12","1","internal","12","1",NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("114","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+","12",NULL,"image-ex","12",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("115","http://peka777.net/files/wp-content/themes/mabar88/images/slider/slider.webp","12",NULL,"image-in","12",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("116","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","12",NULL,"image-ex","12",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("117","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","12",NULL,"image-ex","12",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("118","http://peka777.net/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds&trade;.webp","12",NULL,"image-in","12",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("119","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp","12",NULL,"image-in","12",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("120","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp","12",NULL,"image-in","12",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("121","https://bit.ly/SatelitMabarr88","13",NULL,"external","13",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("122","https://bit.ly/Mabar88","13",NULL,"external","13",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("123","http://peka777.net","13","1","internal","13","1",NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("124","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+","13",NULL,"image-ex","13",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("125","http://peka777.net/files/wp-content/themes/mabar88/images/slider/slider.webp","13",NULL,"image-in","13",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("126","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","13",NULL,"image-ex","13",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("127","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","13",NULL,"image-ex","13",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("128","http://peka777.net/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds&trade;.webp","13",NULL,"image-in","13",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("129","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp","13",NULL,"image-in","13",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("130","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp","13",NULL,"image-in","13",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("131","https://bit.ly/SatelitMabarr88","14",NULL,"external","14",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("132","https://bit.ly/Mabar88","14",NULL,"external","14",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("133","http://peka777.net","14","1","internal","14","1",NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("134","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+","14",NULL,"image-ex","14",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("135","http://peka777.net/files/wp-content/themes/mabar88/images/slider/slider.webp","14",NULL,"image-in","14",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("136","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","14",NULL,"image-ex","14",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("137","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","14",NULL,"image-ex","14",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("138","http://peka777.net/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds&trade;.webp","14",NULL,"image-in","14",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("139","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp","14",NULL,"image-in","14",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("140","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp","14",NULL,"image-in","14",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("141","https://bit.ly/SatelitMabarr88","15",NULL,"external","15",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("142","https://bit.ly/Mabar88","15",NULL,"external","15",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("143","http://peka777.net","15","1","internal","15","1",NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("144","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjYxMyIgd2lkdGg9IjE5MjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIi8+","15",NULL,"image-ex","15",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("145","http://peka777.net/files/wp-content/themes/mabar88/images/slider/slider.webp","15",NULL,"image-in","15",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("146","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjE4MyIgd2lkdGg9IjY0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","15",NULL,"image-ex","15",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("147","data:image/svg+xml;base64,PHN2ZyBoZWlnaHQ9IjIwMCIgd2lkdGg9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2ZXJzaW9uPSIxLjEiLz4=","15",NULL,"image-ex","15",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("148","http://peka777.net/files/wp-content/themes/mabar88/images/games/best games/almighty zeus wilds&trade;.webp","15",NULL,"image-in","15",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("149","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/emperor caishen.webp","15",NULL,"image-in","15",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("150","http://peka777.net/files/wp-content/themes/mabar88/images/games/daily wins/wisdom of athena.webp","15",NULL,"image-in","15",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("151","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp","1",NULL,"image-ex","1",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("152","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp","1",NULL,"image-ex","1",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("153","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp","1",NULL,"image-ex","1",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("154","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp","1",NULL,"image-ex","1",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("155","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp","1",NULL,"image-ex","1",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("156","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp","1",NULL,"image-ex","1",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("157","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp","1",NULL,"image-ex","1",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("158","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp","1",NULL,"image-ex","1",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("159","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp","1",NULL,"image-ex","1",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("160","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp","1",NULL,"image-ex","1",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("161","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp","1",NULL,"image-ex","1",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("162","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp","1",NULL,"image-ex","1",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("163","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp","1",NULL,"image-ex","1",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("164","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp","1",NULL,"image-ex","1",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("165","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp","1",NULL,"image-ex","1",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("166","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp","2",NULL,"image-ex","2",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("167","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp","2",NULL,"image-ex","2",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("168","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp","2",NULL,"image-ex","2",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("169","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp","2",NULL,"image-ex","2",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("170","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp","2",NULL,"image-ex","2",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("171","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp","2",NULL,"image-ex","2",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("172","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp","2",NULL,"image-ex","2",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("173","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp","2",NULL,"image-ex","2",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("174","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp","2",NULL,"image-ex","2",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("175","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp","2",NULL,"image-ex","2",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("176","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp","2",NULL,"image-ex","2",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("177","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp","2",NULL,"image-ex","2",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("178","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp","2",NULL,"image-ex","2",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("179","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp","2",NULL,"image-ex","2",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("180","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp","2",NULL,"image-ex","2",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("181","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp","3",NULL,"image-ex","3",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("182","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp","3",NULL,"image-ex","3",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("183","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp","3",NULL,"image-ex","3",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("184","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp","3",NULL,"image-ex","3",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("185","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp","3",NULL,"image-ex","3",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("186","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp","3",NULL,"image-ex","3",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("187","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp","3",NULL,"image-ex","3",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("188","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp","3",NULL,"image-ex","3",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("189","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp","3",NULL,"image-ex","3",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("190","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp","3",NULL,"image-ex","3",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("191","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp","3",NULL,"image-ex","3",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("192","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp","3",NULL,"image-ex","3",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("193","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp","3",NULL,"image-ex","3",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("194","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp","3",NULL,"image-ex","3",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("195","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp","3",NULL,"image-ex","3",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("196","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp","4",NULL,"image-ex","4",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("197","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp","4",NULL,"image-ex","4",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("198","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp","4",NULL,"image-ex","4",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("199","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp","4",NULL,"image-ex","4",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("200","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp","4",NULL,"image-ex","4",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("201","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp","4",NULL,"image-ex","4",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("202","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp","4",NULL,"image-ex","4",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("203","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp","4",NULL,"image-ex","4",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("204","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp","4",NULL,"image-ex","4",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("205","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp","4",NULL,"image-ex","4",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("206","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp","4",NULL,"image-ex","4",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("207","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp","4",NULL,"image-ex","4",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("208","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp","4",NULL,"image-ex","4",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("209","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp","4",NULL,"image-ex","4",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("210","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp","4",NULL,"image-ex","4",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("211","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp","5",NULL,"image-ex","5",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("212","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp","5",NULL,"image-ex","5",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("213","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp","5",NULL,"image-ex","5",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("214","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp","5",NULL,"image-ex","5",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("215","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp","5",NULL,"image-ex","5",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("216","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp","5",NULL,"image-ex","5",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("217","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp","5",NULL,"image-ex","5",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("218","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp","5",NULL,"image-ex","5",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("219","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp","5",NULL,"image-ex","5",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("220","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp","5",NULL,"image-ex","5",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("221","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp","5",NULL,"image-ex","5",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("222","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp","5",NULL,"image-ex","5",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("223","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp","5",NULL,"image-ex","5",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("224","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp","5",NULL,"image-ex","5",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("225","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp","5",NULL,"image-ex","5",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("226","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp","6",NULL,"image-ex","6",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("227","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp","6",NULL,"image-ex","6",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("228","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp","6",NULL,"image-ex","6",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("229","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp","6",NULL,"image-ex","6",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("230","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp","6",NULL,"image-ex","6",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("231","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp","6",NULL,"image-ex","6",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("232","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp","6",NULL,"image-ex","6",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("233","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp","6",NULL,"image-ex","6",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("234","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp","6",NULL,"image-ex","6",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("235","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp","6",NULL,"image-ex","6",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("236","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp","6",NULL,"image-ex","6",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("237","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp","6",NULL,"image-ex","6",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("238","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp","6",NULL,"image-ex","6",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("239","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp","6",NULL,"image-ex","6",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("240","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp","6",NULL,"image-ex","6",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("241","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp","7",NULL,"image-ex","7",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("242","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp","7",NULL,"image-ex","7",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("243","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp","7",NULL,"image-ex","7",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("244","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp","7",NULL,"image-ex","7",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("245","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp","7",NULL,"image-ex","7",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("246","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp","7",NULL,"image-ex","7",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("247","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp","7",NULL,"image-ex","7",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("248","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp","7",NULL,"image-ex","7",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("249","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp","7",NULL,"image-ex","7",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("250","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp","7",NULL,"image-ex","7",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("251","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp","7",NULL,"image-ex","7",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("252","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp","7",NULL,"image-ex","7",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("253","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp","7",NULL,"image-ex","7",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("254","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp","7",NULL,"image-ex","7",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("255","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp","7",NULL,"image-ex","7",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("256","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp","8",NULL,"image-ex","8",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("257","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp","8",NULL,"image-ex","8",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("258","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp","8",NULL,"image-ex","8",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("259","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp","8",NULL,"image-ex","8",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("260","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp","8",NULL,"image-ex","8",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("261","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp","8",NULL,"image-ex","8",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("262","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp","8",NULL,"image-ex","8",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("263","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp","8",NULL,"image-ex","8",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("264","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp","8",NULL,"image-ex","8",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("265","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp","8",NULL,"image-ex","8",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("266","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp","8",NULL,"image-ex","8",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("267","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp","8",NULL,"image-ex","8",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("268","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp","8",NULL,"image-ex","8",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("269","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp","8",NULL,"image-ex","8",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("270","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp","8",NULL,"image-ex","8",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("271","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp","9",NULL,"image-ex","9",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("272","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp","9",NULL,"image-ex","9",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("273","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp","9",NULL,"image-ex","9",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("274","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp","9",NULL,"image-ex","9",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("275","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp","9",NULL,"image-ex","9",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("276","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp","9",NULL,"image-ex","9",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("277","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp","9",NULL,"image-ex","9",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("278","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp","9",NULL,"image-ex","9",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("279","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp","9",NULL,"image-ex","9",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("280","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp","9",NULL,"image-ex","9",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("281","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp","9",NULL,"image-ex","9",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("282","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp","9",NULL,"image-ex","9",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("283","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp","9",NULL,"image-ex","9",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("284","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp","9",NULL,"image-ex","9",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("285","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp","9",NULL,"image-ex","9",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("286","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp","10",NULL,"image-ex","10",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("287","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp","10",NULL,"image-ex","10",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("288","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp","10",NULL,"image-ex","10",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("289","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp","10",NULL,"image-ex","10",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("290","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp","10",NULL,"image-ex","10",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("291","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp","10",NULL,"image-ex","10",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("292","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp","10",NULL,"image-ex","10",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("293","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp","10",NULL,"image-ex","10",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("294","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp","10",NULL,"image-ex","10",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("295","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp","10",NULL,"image-ex","10",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("296","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp","10",NULL,"image-ex","10",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("297","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp","10",NULL,"image-ex","10",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("298","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp","10",NULL,"image-ex","10",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("299","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp","10",NULL,"image-ex","10",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("300","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp","10",NULL,"image-ex","10",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("301","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp","11",NULL,"image-ex","11",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("302","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp","11",NULL,"image-ex","11",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("303","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp","11",NULL,"image-ex","11",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("304","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp","11",NULL,"image-ex","11",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("305","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp","11",NULL,"image-ex","11",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("306","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp","11",NULL,"image-ex","11",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("307","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp","11",NULL,"image-ex","11",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("308","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp","11",NULL,"image-ex","11",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("309","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp","11",NULL,"image-ex","11",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("310","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp","11",NULL,"image-ex","11",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("311","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp","11",NULL,"image-ex","11",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("312","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp","11",NULL,"image-ex","11",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("313","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp","11",NULL,"image-ex","11",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("314","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp","11",NULL,"image-ex","11",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("315","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp","11",NULL,"image-ex","11",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("316","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp","12",NULL,"image-ex","12",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("317","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp","12",NULL,"image-ex","12",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("318","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp","12",NULL,"image-ex","12",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("319","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp","12",NULL,"image-ex","12",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("320","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp","12",NULL,"image-ex","12",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("321","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp","12",NULL,"image-ex","12",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("322","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp","12",NULL,"image-ex","12",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("323","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp","12",NULL,"image-ex","12",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("324","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp","12",NULL,"image-ex","12",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("325","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp","12",NULL,"image-ex","12",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("326","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp","12",NULL,"image-ex","12",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("327","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp","12",NULL,"image-ex","12",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("328","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp","12",NULL,"image-ex","12",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("329","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp","12",NULL,"image-ex","12",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("330","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp","12",NULL,"image-ex","12",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("331","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp","13",NULL,"image-ex","13",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("332","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp","13",NULL,"image-ex","13",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("333","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp","13",NULL,"image-ex","13",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("334","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp","13",NULL,"image-ex","13",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("335","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp","13",NULL,"image-ex","13",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("336","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp","13",NULL,"image-ex","13",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("337","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp","13",NULL,"image-ex","13",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("338","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp","13",NULL,"image-ex","13",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("339","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp","13",NULL,"image-ex","13",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("340","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp","13",NULL,"image-ex","13",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("341","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp","13",NULL,"image-ex","13",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("342","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp","13",NULL,"image-ex","13",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("343","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp","13",NULL,"image-ex","13",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("344","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp","13",NULL,"image-ex","13",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("345","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp","13",NULL,"image-ex","13",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("346","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp","14",NULL,"image-ex","14",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("347","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp","14",NULL,"image-ex","14",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("348","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp","14",NULL,"image-ex","14",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("349","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp","14",NULL,"image-ex","14",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("350","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp","14",NULL,"image-ex","14",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("351","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp","14",NULL,"image-ex","14",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("352","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp","14",NULL,"image-ex","14",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("353","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp","14",NULL,"image-ex","14",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("354","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp","14",NULL,"image-ex","14",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("355","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp","14",NULL,"image-ex","14",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("356","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp","14",NULL,"image-ex","14",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("357","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp","14",NULL,"image-ex","14",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("358","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp","14",NULL,"image-ex","14",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("359","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp","14",NULL,"image-ex","14",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("360","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp","14",NULL,"image-ex","14",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("361","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Mahjong%20Wins%203.webp","15",NULL,"image-ex","15",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("362","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Lucky%20Twins%20Nexus.webp","15",NULL,"image-ex","15",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("363","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Fortune%20Gods.webp","15",NULL,"image-ex","15",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("364","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/SixSixSix.webp","15",NULL,"image-ex","15",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("365","https://peka777.net/wp-content/themes/mabar88/images/games/Best%20Games/Beam%20Boys.webp","15",NULL,"image-ex","15",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("366","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/5%20Lions%20Megaways.webp","15",NULL,"image-ex","15",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("367","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Release%20the%20Kraken%202.webp","15",NULL,"image-ex","15",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("368","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Aztec%20Bonanza.webp","15",NULL,"image-ex","15",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("369","https://peka777.net/wp-content/themes/mabar88/images/games/Daily%20Wins/Rujak%20Bonanza.webp","15",NULL,"image-ex","15",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("370","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Lucky%20Neko.webp","15",NULL,"image-ex","15",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("371","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Fortune%20Tiger.webp","15",NULL,"image-ex","15",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("372","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Treasures%20of%20Aztec.webp","15",NULL,"image-ex","15",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("373","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Wild%20Bandito.webp","15",NULL,"image-ex","15",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("374","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Dreams%20of%20Macau.webp","15",NULL,"image-ex","15",NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES("375","https://peka777.net/wp-content/themes/mabar88/images/games/Hot%20Games/Rooster%20Rumble.webp","15",NULL,"image-ex","15",NULL,NULL,NULL,NULL,NULL,NULL);



